/**
 * OW2 Specifications
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SharedCacheMode.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

/**
 * The enum javax.persistence.SharedCacheMode defines the use of caching. The persis- tence.xml shared-cache-mode element has no
 * default value. The getSharedCacheMode method must return UNSPECIFIED if the shared-cache-mode element has not been specified
 * for the persistence unit.
 * @see <a href="http://jcp.org/en/jsr/detail?id=317">JPA 2.0 specification</a>
 * @author Florent Benoit
 * @since JPA 2.0 version.
 */
public enum SharedCacheMode {
    /**
     * All entities and entity-related state and data are cached.
     */
    ALL,

    /**
     * Caching is disabled for the persistence unit.
     */
    NONE,

    /**
     * Caching is enabled for all entities for Cacheable(true) is specified.
     */
    ENABLE_SELECTIVE,

    /**
     * Caching is enabled for all entities except those for which Cacheable(false) is specified.
     */
    DISABLE_SELECTIVE,

    /**
     * Caching behavior is undefined: provider-specific defaults may apply.
     */
    UNSPECIFIED
}
