/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: WebMethod.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.jws;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.rmi.RemoteException;

/**
 * Customizes a method that is exposed as a Web Service operation.
 * The associated method must be public and its parameters return
 * value, and exceptions must follow the rules defined in JAX-RPC
 * 1.1, section 5. The method is not required to throw {@link RemoteException}.
 * @author Guillaume Sauthier
 */
@Retention(value=RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface WebMethod {

    /**
     * The action for this operation.<br/>
     * For SOAP bindings, this determines the value of the soap action.
     */
    String action() default "";

    /**
     * Marks a method to NOT be exposed as a web method.<br/>
     * Used to stop an inherited method from being exposed as part
     * of this web service. If this element is specified, other
     * elements MUST NOT be specified for the @WebMethod.<br/>
     *
     * This member-value is not allowed on endpoint interfaces.
     * @since 2.0
     */
    boolean exclude() default false;

    /**
     * Name of the wsdl:operation matching this method.
     */
    String operationName() default "";
}
