/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: SOAPMessageHandlers.java 6345 2013-02-18 14:10:35Z albertil $
 * --------------------------------------------------------------------------
 */

package javax.jws.soap;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Specifies a list of SOAP protocol handlers that run before
 * and after business methods on the Web Service. These handlers
 * are called in response to SOAP messages targeting the service.<br/>
 *
 * The @SOAPMessageHandlers annotation is an array of SOAPMessageHandler
 * types. The handlers are run in the order in which they appear in
 * the annotation, starting with the first handler in the array.
 * @author Guillaume Sauthier
 * @deprecated
 */
@Deprecated
@Retention(value=RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface SOAPMessageHandlers {

    /**
     */
    SOAPMessageHandler[] value();
}
