/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Dependent.java 5375 2010-02-25 17:25:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.context;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.inject.Scope;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Specifies that a bean belongs to the dependent pseudo-scope.
 *
 * Beans declared with scope {@code @Dependent} behave differently to beans with other built-in scope types.
 * When a bean is declared to have scope {@code @Dependent}:
 * <ul>
 *  <li>No injected instance of the bean is ever shared between multiple injection points.</li>
 *  <li>Any instance of the bean injected into an object that is being created by the container is bound
 *      to the life-cycle of the newly created object.</li>
 *  <li>When a Unified EL expression in a JSF or JSP page that refers to the bean by its EL name is evaluated,
 *      at most one instance of the bean is instantiated. This instance exists to service just a single
 *      evaluation of the EL expression. It is reused if the bean EL name appears multiple times in the
 *      EL expression, but is never reused when the EL expression is evaluated again, or when another EL
 *      expression is evaluated.</li>
 *  <li>Any instance of the bean that receives a producer method, producer field, disposer method or observer
 *      method invocation exists to service that invocation only.</li>
 *  <li>Any instance of the bean injected into method parameters of a disposer method or observer method
 *      exists to service the method invocation only.</li>
 * </ul>
 *
 * Every invocation of the {@link javax.enterprise.context.spi.Context#get(Contextual, CreationalContext)}
 * operation of the context object for the {@code @Dependent} scope returns a new instance of the given bean.
 *
 * Every invocation of the {@link javax.enterprise.context.spi.Context#get(Contextual)} operation of the
 * context object for the {@code @Dependent} scope returns a {@code null} value.
 *
 * The {@code @Dependent} scope is always active.
 *
 * Many instances of beans with scope @Dependent belong to some other bean or Java EE component class
 * instance and are called dependent objects.
 * <ul>
 *  <li>Instances of decorators and interceptors are dependent objects of the bean instance they decorate.</li>
 *  <li>An instance of a bean with scope {@code @Dependent} injected into a field, bean constructor or initializer
 *      method is a dependent object of the bean or Java EE component class instance into which it was injected.</li>
 *  <li>An instance of a bean with scope {@code @Dependent} injected into a producer method is a dependent
 *      object of the producer method bean instance that is being produced.</li>
 *  <li>An instance of a bean with scope {@code @Dependent} obtained by direct invocation of an
 *      {@link javax.enterprise.inject.Instance} is a dependent object of the instance of
 *      {@link javax.enterprise.inject.Instance}.</li>
 * </ul>
 *
 * When the container destroys an instance of a bean or of any Java EE component class supporting injection,
 * the container destroys all its dependent objects, after the <code>@PreDestroy</code> callback completes
 * and after the servlet <code>destroy()</code> method is called.
 *
 * @author Guillaume Sauthier
 *
 * @since CDI 1.0
 *
 */
@Target({METHOD, TYPE, FIELD})
@Retention(RUNTIME)
@Documented
@Scope
@Inherited
public @interface Dependent {}