/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: RequestScoped.java 5375 2010-02-25 17:25:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.context;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Specifies that a bean is request scoped.
 *
 * The request scope is active:
 * <ul>
 *  <li>during the <code>service()</code> method of any servlet in the web application, during the
 *      <code>doFilter()</code> method of any servlet filter and when the container calls any
 *      <code>ServletRequestListener</code> or <code>AsyncListener</code>,</li>
 *  <li>during any Java EE web service invocation,</li>
 *  <li>during any asynchronous observer method notification,</li>
 *  <li>during any remote method invocation of any EJB, during any asynchronous method invocation of any EJB,
 *      during any call to an EJB timeout method and during message delivery to any EJB message-driven bean, and</li>
 *  <li>during any message delivery to a <code>MessageListener</code> for a JMS topic or queue obtained from
 *      the Java EE component environment.</li>
 * </ul>
 *
 * The request context is destroyed:
 * <ul>
 *  <li>at the end of the servlet request, after the <code>service()</code> method, all <code>doFilter()</code>
 *      methods, and all <code>requestDestroyed()</code> and <code>onComplete()</code> notifications return,</li>
 *  <li>after the web service invocation completes,</li>
 *  <li>after the asynchronous observer notification completes,</li>
 *  <li>after the EJB remote method invocation, asynchronous method invocation, timeout or message delivery completes, or</li>
 *  <li>after the message delivery to the {@code MessageListener} completes.</li>
 * </ul>
 *
 * @author Guillaume Sauthier
 * @since CDI 1.0
 */
@Target({TYPE, METHOD, FIELD})
@Retention(RUNTIME)
@Documented
@NormalScope
@Inherited
public @interface RequestScoped {}