/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SessionScoped.java 5375 2010-02-25 17:25:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.context;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Specifies that a bean is session scoped.
 *
 * The session scope is active:
 * <ul>
 *  <li>during the <code>service()</code> method of any servlet in the web application, during the
 *      <code>doFilter()</code> method of any servlet filter and when the container calls any
 *      <code>HttpSessionListener</code>, <code>AsyncListener</code> or <code>ServletRequestListener</code>.</li>
 * </ul>
 *
 * The session context is shared between all servlet requests that occur in the same HTTP session.
 * The session context is destroyed when the HTTPSession times out, after all HttpSessionListeners have been
 * called, and at the very end of any request in which <code>invalidate()</code> was called, after all filters and
 * {@code ServletRequestListeners} have been called.
 *
 * @author Guillaume Sauthier
 * @since CDI 1.0
 */
@Target({TYPE, METHOD, FIELD})
@Retention(RUNTIME)
@Documented
@NormalScope(passivating = true)
@Inherited
public @interface SessionScoped {}
