/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Contextual.java 5375 2010-02-25 17:25:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.context.spi;

import javax.enterprise.inject.CreationException;

/**
 * Defines operations to create and destroy contextual instances of a certain type. Any
 * implementation of Contextual is called a contextual type. In particular, all beans
 * are contextual types.
 *
 * @author Guillaume Sauthier
 * @see javax.enterprise.inject.spi.Bean
 */
public interface Contextual<T> {

    /**
     * Create a new instance of the contextual type. Instances should use the given
     * {@link javax.enterprise.context.spi.CreationalContext} when obtaining contextual references
     * to inject, in order to ensure that any dependent objects are associated with the contextual
     * instance that is being created. An implementation may call {@link javax.enterprise.context.spi.CreationalContext#push(Object)}
     * between instantiation and injection to help the container minimize the use of client proxy objects.
     *
     * @param creationalContext the context in which this instance is being created 
     * @return the contextual instance
     * @throws CreationException if a checked exception occurs while creating the instance
     */
    T create(CreationalContext<T> creationalContext);

    /**
     * Destroy an instance of the contextual type. Implementations should call
     * {@link javax.enterprise.context.spi.CreationalContext#release()} to allow the container to destroy
     * dependent objects of the contextual instance.
     *  
     * @param instance the contextual instance to destroy
     * @param creationalContext the context in which this instance was created
     */
    void destroy(T instance, CreationalContext<T> creationalContext);
}
