/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: package-info.java 5375 2010-02-25 17:25:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

/**
 * Annotations relating to bean and stereotype definition, built-in qualifiers, and interfaces and classes relating to programmatic lookup.
 *
 * A bean is a source of contextual objects which define application state and/or logic. These objects are called contextual instances of the bean. The container creates and destroys these instances and associates them with the appropriate context. Contextual instances of a bean may be injected into other objects (including other bean instances) that execute in the same context, and may be used in Unified EL expressions that are evaluated in the same context.
 *
 * The life-cycle of contextual instances is managed by the container according to the life-cycle context model. Annotations define the life-cycle of the bean and its interactions with other beans.
 *
 * A bean comprises the following attributes:
 * <ul>
 *  <li>A (nonempty) set of bean types</li>
 *  <li>A (nonempty) set of qualifiers</li>
 *  <li>A scope</li>
 *  <li>Optionally, a bean EL name</li>
 *  <li>A set of interceptor bindings</li>
 *  <li>A bean implementation</li>
 * </ul>
 *
 * <h1>Bean types</h1>
 *
 * A bean type is a client-visible type of the bean. A bean may have multiple bean types. The following bean has bean types BookShop, Business, Shop&lt;Book> and Object.
 *
 * <pre>
 public class BookShop
       extends Business
       implements Shop&lt;Book> {
    ...
 }
 * </pre>
 *
 * Almost any Java type may be a bean type of a bean:
 * <ul>
 *  <li>A bean type may be an interface, a concrete class or an abstract class, and may be declared final or have final methods.</li>
 *  <li>A bean type may be a parameterized type with actual type parameters and type variables.</li>
 *  <li>A bean type may be an array type. Two array types are considered identical only if the element type is identical.</li>
 *  <li>A bean type may be a primitive type. Primitive types are considered to be identical to their corresponding wrapper types in java.lang.</li>
 *  <li>A bean type may be a raw type.</li>
 * </ul>
 *
 * A type variable is not a legal bean type. A parameterized type that contains a wildcard type parameter is not a legal bean type.
 *
 * The bean types of a bean are determined automatically. However, the set of bean types may be resticted using the @Typed annotation.
 *
 * <h1>Qualifiers</h1>
 *
 * A qualifier represents some client-visible semantic associated with a type that is satisfied by some implementations of the type (and not by others). Qualifiers are applied to injection points to distinguish which implementation is required by the client.
 * <pre>
 &#064;Inject @Synchronous PaymentProcessor paymentProcessor;
 * </pre>
 *
 * A qualifier type is a Java annotation annotated @Qualifier. The qualifiers of a bean are declared by annotating the bean class or producer method or field with the qualifier types.
 * <pre>
 &#064;Synchronous @Reliable
 class SynchronousReliablePaymentProcessor
       implements PaymentProcessor {
    ...
 }
 * </pre>
 *
 * If a bean does not explicitly declare a qualifier other than @Named, the bean has the qualifier @Default.
 *
 * <h1>Scope</h1>
 *
 * All beans have a scope. The scope of a bean determines the lifecycle of its instances, and which instances of the bean are visible to instances of other beans.
 *
 * A scope type is a Java annotation annotated @Scope or @NormalScope. The scope of a bean is defined by annotating the bean class or producer method or field with a scope type or with a stereotype that declares a default scope.
 * <pre>
 &#064;ConversationScoped
 public class Order { ... }
 * </pre>
 *
 * A bean class or producer method or field may specify at most one scope type annotation.
 *
 * If the bean does not explicitly declare a scope or a stereotype with a default scope, the scope defaults to @Dependent.
 *
 * <li>Bean EL name</li>
 *
 * A bean may have a bean EL name. A bean with an EL name may be referred to by its name in Unified EL expressions. A valid bean EL name is a period-separated list of valid EL identifiers.
 *
 * To specify the EL name of a bean, the qualifier @Named is applied to the bean class or producer method or field.
 * <pre>
 &#064;Named("currentOrder")
 public class Order { ... }
 * </pre>
 *
 * If the @Named annotation does not specify the value member, the EL name is defaulted.
 *
 * <h1>Interceptor bindings</h1>
 *
 * Interceptors may be bound to any managed bean that is not itself an interceptor or decorator or to any EJB session or message-driven bean. An interceptor that is annotated @Interceptor may be identified by its interceptor bindings.
 * <pre>
 &#064;Transactional @Interceptor
 public class TransactionInterceptor {
    &#064;AroundInvoke
    public Object manageTransaction(InvocationContext ctx) { ... }
 }
 * </pre>
 *
 * An interceptor binding type is a Java annotation annotated @InterceptorBinding. An interceptor binding of a bean may be declared by annotating the bean class, or a method of the bean class, with an interceptor binding type or with a stereotype that declares the interceptor binding.
 *
 * In the following example, the TransactionInterceptor will be applied at the class level, and therefore applies to all business methods of the class:
 * <pre>
 &#064;Transactional
 public class ShoppingCart { ... }
 * </pre>
 *
 * In this example, the TransactionInterceptor will be applied at the method level:
 * <pre>
 public class ShoppingCart {
    &#064;Transactional
    public void placeOrder() { ... }
 }
 * </pre>
 *
 * If a managed bean class is declared final, it may not have any interceptor bindings. If a managed bean has a non-static, non-private, final method, it may not have any class-level interceptor bindings, and that method may not have any method-level interceptor bindings.
 *
 * <h1>Bean implementation<h1>
 *
 * The container provides built-in support for injection and contextual life-cycle management of the following kinds of bean:
 * <ul>
 *  <li>Managed beans</li>
 *  <li>Session beans</li>
 *  <li>Producer methods and fields</li>
 *  <li>Resources (Java EE resources, persistence contexts, persistence units, remote EJBs and web services)</li>
 * </ul>
 *
 * <h1>Managed beans</h1>
 *
 * A managed bean is a bean that is implemented by a Java class. The basic lifecycle and semantics of managed beans are defined by the Managed Beans specification.
 *
 * A top-level Java class is a managed bean if it is defined to be a managed bean by any other Java EE specification, or if it meets all of the following conditions:
 * <ul>
 *  <li>It is not a non-static inner class.</li>
 *  <li>It is a concrete class, or is annotated @Decorator.</li>
 *  <li>It is not annotated with an EJB component-defining annotation or declared as an EJB bean class in ejb-jar.xml.</li>
 *  <li>It does not implement Extension.</li>
 *  <li>It has an appropriate constructor; either the class has a constructor with no parameters, or the class declares a constructor annotated @Inject.</li>
 * </ul>
 *
 * All Java classes that meet these conditions are managed beans and thus no special declaration is required to define a managed bean. Optionally, a managed bean may be annotated javax.annotation.ManagedBean.
 *
 * If a managed bean has a public field, it must have scope @Dependent.
 *
 * If the managed bean class is a generic type, it must have scope @Dependent.
 *
 * <h1>Session beans</h1>
 *
 * The basic life-cycle and semantics of EJB session beans are defined by the EJB specification.
 * <ul>
 *  <li>A stateless session bean must belong to the @Dependent pseudo-scope.</li>
 *  <li>A singleton bean must belong to either the @ApplicationScoped scope or to the @Dependent pseudo-scope.</li>
 *  <li>A stateful session bean may have any scope.</li>
 * </ul>
 *
 * If the session bean class is a generic type, it must have scope @Dependent.
 *
 * If a session bean is a stateful session bean:
 * <ul>
 *  <li>If the scope is @Dependent, the application may call any EJB remove method of a contextual instance of the session bean.</li>
 *  <li>Otherwise, the application may not directly call any EJB remove method of any contextual instance of the session bean.</li>
 * </ul>
 *
 * <h1>Producer methods and fields</h1>
 *
 * A producer method or field acts as a source of objects to be injected, where:
 * <ul>
 *  <li>the objects to be injected are not required to be instances of beans, or</li>
 *  <li>the concrete type of the objects to be injected may vary at runtime, or</li>
 *  <li>the objects require some custom initialization that is not performed by the bean constructor.</li>
 * </ul>
 *
 * A producer method or field is a method or field of a bean class annotated @Produces.
 *
 * A common pattern in generic code is a producer method that injects an InjectionPoint object.
 *
 * <h1>Resources</h1>
 *
 * A resource is a bean that represents a reference to a resource, persistence context, persistence unit, remote EJB or web service in the Java EE component environment.
 *
 * A resource may be declared by specifying a Java EE component environment injection annotation as part of a producer field declaration.
 * <ul>
 *  <li>For a Java EE resource, @Resource must be specified.</li>
 *  <li>For a persistence context, @PersistenceContext must be specified.</li>
 *  <li>For a persistence unit, @PersistenceUnit must be specified.</li>
 *  <li>For a remote EJB, @EJB must be specified.</li>
 *  <li>or a web service, @WebServiceRef must be specified.</li>
 * </ul>
 *
 * The injection annotation specifies the metadata needed to obtain the resources, entity manager, entity manager factory, remote EJB instance or web service reference from the component environment.
 * <pre>
 &#064;Produces @WebServiceRef(lookup="java:app/service/PaymentService")
 PaymentService paymentService;


 &#064;Produces @EJB(ejbLink="../their.jar#PaymentService")
 PaymentService paymentService;


 &#064;Produces @Resource(lookup="java:global/env/jdbc/CustomerDatasource")
 &#064;CustomerDatabase Datasource customerDatabase;


 &#064;Produces @PersistenceContext(unitName="CustomerDatabase")
 &#064;CustomerDatabase EntityManager customerDatabasePersistenceContext;


 &#064;Produces @PersistenceUnit(unitName="CustomerDatabase")
 &#064;CustomerDatabase EntityManagerFactory customerDatabasePersistenceUnit;
 * </pre>
 *
 * A resource may not have an EL name.
 *
 * <h1>Enabled and disabled beans</h1>
 *
 * A bean is said to be enabled if:
 * <ul>
 *  <li>it is deployed in a bean archive, and</li>
 *  <li>it is not a producer method or field of a disabled bean, and</li>
 *  <li>it is not specialized by any other enabled bean, and either</li>
 *  <li>it is not an alternative, or it is a selected alternative of at least one bean archive.</li>
 * </ul>
 *
 * Otherwise, the bean is said to be disabled.
 *
 * <h1>Inter-module injection</h1>
 *
 * Beans and their clients may be deployed in modules in a module architecture such as the Java EE environment. In a module architecture, certain modules are considered bean archives. In the Java EE module architecture, any Java EE module or library is a module. The Java EE module or library is a bean archive if it contains a beans.xml file in the metadata directory.
 *
 * A bean is available for injection in a certain module if:
 * <ul>
 *  <li>the bean is not an interceptor or decorator,</li>
 *  <li>the bean is enabled,</li>
 *  <li>the bean is either not an alternative, or the module is a bean archive and the bean is a selected alternative of the bean archive, and</li>
 *  <li>the bean class is required to be accessible to classes in the module, according to the class accessibility requirements of the module architecture.</li>
 * </ul>
 *
 * <h1>Dependency injection</h1>
 *
 * A bean is assignable to a given injection point if:
 * <ul>
 *  <li>The bean has a bean type that matches the type of the injection point. For this purpose, primitive types are considered to match their corresponding wrapper types in java.lang and array types are considered to match only if their element types are identical.</li>
 *  <li>The bean has all the qualifiers of the injection point. If the injection point does not explicitly declare a qualifier, it has the default qualifier @Default.</li>
 *  <li>The bean is eligible for injection into the class that declares the injection point.</li>
 * </ul>
 *
 * A bean is eligible for injection into a given injection point if:
 * <ul>
 *  <li>it is available for injection in the module that contains the class that declares the injection point, and</li>
 *  <li>it is assignable to the injection point.</li>
 * </ul>
 *
 * If more than one bean is eligible for injection to the injection point, the container attempts to resolve the ambiguity by eliminating all beans which are not alternatives, except for producer methods and fields of beans that are alternatives.
 *
 * Certain legal bean types cannot be proxied by the container:
 * <ul>
 *  <li>classes which don't have a non-private constructor with no parameters,</li>
 *  <li>classes which are declared final or have final methods,</li>
 *  <li>primitive types,</li>
 *  <li>and array types.</li>
 * </ul>
 *
 * An injection point whose declared type cannot be proxied by the container must not resolve to a bean with a normal scope.
 *
 * <h1>EL name resolution</h1>
 *
 * EL names are resolved when Unified EL expressions are evaluated. An EL name resolves to a bean if:
 * <ul>
 *  <li>the bean has the given EL name, and</li>
 *  <li>the bean is available for injection in the war containing the JSP or JSF page with the EL expression.</li>
 * </ul>
 *
 * If an EL name resolves to more than one bean, the container attempts to resolve the ambiguity by eliminating all beans which are not alternatives, except for producer methods and fields of beans that are alternatives.
 *
 * <h1>Enabled interceptors</h1>
 *
 * By default, a bean archive has no enabled interceptors. An interceptor must be explicitly enabled by listing its bean class under the <interceptors> element of the beans.xml file of the bean archive. The order of the interceptor declarations determines the interceptor ordering. Interceptors which occur earlier in the list are called first.
 *
 * An interceptor is bound to a bean if:
 * <ul>
 *  <li>The bean has all the interceptor bindings of the interceptor.</li>
 *  <li>The interceptor is enabled in the bean archive of the bean.</li>
 * </ul>
 *
 * An interceptor instance is a dependent object of the object it intercepts.
 *
 * @see javax.enterprise.inject
 * @see javax.enterprise.context.spi
 */
package javax.enterprise.inject;