/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: MessageListener.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.cci;
 
import javax.resource.ResourceException;

/**
 * This serves as a request-response message listener type that
 * message endpoints (message-driven beans) may implement. This
 * allows an EIS to communicate with an endpoint using a
 * request-response style.
 * @version 1.0
 * @author Guillaume Sauthier
 */
public interface MessageListener {

    /**
     * This method allows an EIS to call a message endpoint using
     * a request-response style communication.
     * @param inputData a Record instance.
     * @return a Record instance or null.
     * @throws ResourceException indicates an exceptional condition.
     */
    Record onMessage(Record inputData) throws ResourceException;
}
