/**
 * OW2 Specifications
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AuthenticationMechanism.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/** 
 * @since 1.6
 * @author Florent Benoit
 */
@Documented
@Target({})
@Retention(RUNTIME)
public @interface AuthenticationMechanism {

    public enum CredentialInterface {
        /**
         * Corresponds to javax.resource.spi.security.GenericCredential.
         */
        GenericCredential,
        
        /**
         *  Corresponds to org.ietf.jgss.GSSCredential
         */
        GSSCredential,
        
        /**
         * Corresponds to javax.resource.spi.security.PasswordCredential.
         */
        PasswordCredential
    }
    
    /**
     * The authentication-mechanismType specifies an authentication mechanism supported by the resource adapter. Note that this support is for the resource adapter and not for the underlying EIS instance. 
     */
    String authMechanism() default "BasicPassword";
    
    /**
     * The optional description specifies any resource adapter specific requirement for the support of security contract and authentication mechanism. 
     */
    String[] description() default {};
    
    /**
     * Represents the interface that the resource adapter implementation supports for the representation of the credentials. Note that BasicPassword mechanism type should support the javax.resource.spi.security.PasswordCredential interface. The Kerbv5 mechanism type should support the org.ietf.jgss.GSSCredential interface or the deprecated javax.resource.spi.security.GenericCredential interface.  
     */
    AuthenticationMechanism.CredentialInterface credentialInterface() default CredentialInterface.PasswordCredential;    
}
