/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CommException.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */
 
package javax.resource.spi;

import javax.resource.ResourceException;

/**
 * This indicates errors related to failed or interrupted communication
 * with an EIS instance. Examples of common error conditions represented
 * by this exception type are communication protocol error and invalidated
 * connection due to server failure.
 * @version 1.0
 * @author Guillaume Sauthier
 */
public class CommException extends ResourceException {

    /**
     * Serial version UID.
     */
    private static final long serialVersionUID = 5000980212339163591L;

    /**
     * {@inheritDoc}}
     */
    public CommException() { }

    /**
     * {@inheritDoc}}
     */
    public CommException(String message) {
        super(message);
    }

    /**
     * {@inheritDoc}}
     */
    public CommException(Throwable cause) {
        super(cause);
    }

    /**
     * {@inheritDoc}}
     */
    public CommException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * {@inheritDoc}}
     */
    public CommException(String message, String errorCode) {
        super(message, errorCode);
    }

}
