/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConnectionManager.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import java.io.Serializable;

import javax.resource.ResourceException;
 
/**
 * ConnectionManager interface provides a hook for the resource
 * adapter to pass a connection request to the application server.<br/>
 * 
 * An application server provides implementation of the ConnectionManager
 * interface. This implementation is not specific to any particular type
 * of the resource adapter or connection factory interface.<br/>
 * 
 * The ConnectionManager implementation delegates to the application
 * server to enable latter to provide quality of services (QoS) -
 * security, connection pool management, transaction management
 * and error logging/tracing.<br/>
 * 
 * An application server implements these services in a generic
 * manner, independent of any resource adapter and EIS specific
 * mechanisms. The connector architecture does not specify how an
 * application server implements these services; the implementation
 * is specific to an application server.<br/>
 * 
 * After an application server hooks-in its services, the connection
 * request gets delegated to a ManagedConnectionFactory instance
 * either for the creation of a new physical connection or for the
 * matching of an already existing physical connection.<br/>
 * 
 * An implementation class for ConnectionManager interface is required
 * to implement the java.io.Serializable interface.<br/>
 * 
 * In the non-managed application scenario, the ConnectionManager
 * implementation class can be provided either by a resource adapter
 * (as a default ConnectionManager implementation) or by application
 * developers. In both cases, QOS can be provided as components by
 * third party vendors.
 * @vendor 0.6
 * @author Guillaume Sauthier
 */
public interface ConnectionManager extends Serializable {

    /**
     * The method allocateConnection gets called by the resource
     * adapter's connection factory instance. This lets connection
     * factory instance (provided by the resource adapter) pass a
     * connection request to the ConnectionManager instance.<br/>
     * 
     * The connectionRequestInfo parameter represents informatio
     * specific to the resource adapter for handling of the connection
     * request.
     * @param mcf used by application server to delegate connection
     *        matching/creation
     * @param cxRequestInfo connection request Information
     * @return connection handle with an EIS specific connection
     *         interface.
     * @throws ResourceException Generic exception
     * @throws ApplicationServerInternalException Application server
     *         specific exception
     * @throws SecurityException Security related error
     * @throws ResourceAllocationException Failed to allocate system
     *         resources for connection request
     * @throws ResourceAdapterInternalException Resource adapter
     *         related error condition
     */
    Object allocateConnection(ManagedConnectionFactory mcf,
                              ConnectionRequestInfo cxRequestInfo)
           throws ResourceException;
}
