/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IllegalStateException.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import javax.resource.ResourceException;
 
/**
 * An IllegalStateException is thrown from a method if the callee (resource
 * adapter or application server for system contracts) is in an illegal or
 * inappropriate state for the method invocation.
 * @version 1.0
 * @author Guillaume Sauthier
 */
public class IllegalStateException extends ResourceException {

    /**
     * Serial version UID.
     */
    private static final long serialVersionUID = 3473092818417322126L;

    /**
     * {@inheritDoc}
     */
    public IllegalStateException() {
    }

    /**
     * {@inheritDoc}
     */
    public IllegalStateException(String message) {
        super(message);
    }

    /**
     * {@inheritDoc}
     */
    public IllegalStateException(Throwable cause) {
        super(cause);
    }

    /**
     * {@inheritDoc}
     */
    public IllegalStateException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * {@inheritDoc}
     */
    public IllegalStateException(String message, String errorCode) {
        super(message, errorCode);
    }

}
