/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ResourceAdapterAssociation.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import javax.resource.ResourceException;
 
/**
 * This interface specifies the methods to associate a ResourceAdapter
 * object with other objects that implement this interface like
 * ManagedConnectionFactory and ActivationSpec.
 * @version 1.0
 * @author Guillaume Sauthier
 */
public interface ResourceAdapterAssociation {

    /**
     * Get the associated ResourceAdapter object.
     * @return the associated ResourceAdapter object.
     */
    ResourceAdapter getResourceAdapter();
    
    /**
     * Associate this object with a ResourceAdapter object. Note,
     * this method must be called exactly once. That is, the association
     * must not change during the lifetime of this object.
     * @param ra ResourceAdapter object to be associated with.
     * @throws ResourceException generic exception.
     * @throws ResourceAdapterInternalException resource adapter
     *         related error condition.
     * @throws IllegalStateException indicates that this object is in
     *         an illegal state for the method invocation. For example,
     *         this occurs when this method is called more than once on
     *         the same object.
     */
    void setResourceAdapter(ResourceAdapter ra) throws ResourceException;
}
