/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SecurityException.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import javax.resource.ResourceException;

/**
 * A SecurityException indicates error conditions related to the security
 * contract between an application server and resource adapter. The
 * common error conditions represented by this exception are:<br/>
 * <ul>
 *   <li>Invalid security information (represented as a Subject instance)
 *   passed across the security contract - for example, credentials have
 *   expired or have invalid format.</li>
 *   <li>Lack of support for a specific security mechanism in an EIS or
 *   resource adapter.</li>
 *   <li>Failure to create a connection to an EIS because of failed
 *   authentication or authorization.</li>
 *   <li>Failure to authenticate a resource principal to an EIS instance
 *   or failure to establish a secure association with an underlying EIS
 *   instance.</li>
 *   <li>Access control exception to indicate that a requested access to
 *   an EIS resource or a request to create a new connection is denied.</li>
 * </ul>  
 *@version 1.0
 * @author Guillaume Sauthier
 */
public class SecurityException extends ResourceException {

    /**
     * Serial version UID.
     */
    private static final long serialVersionUID = -7609456980660658364L;

    /**
     * Constructs a new instance with null as its detail message.
     */
    public SecurityException() {
        super();
    }

    /**
     * Constructs a new instance with the specified detail message.
     * @param message the detail message.
     */
    public SecurityException(String message) {
        super(message);
    }

    /**
     * Constructs a new throwable with the specified cause.
     * @param cause a chained exception of type Throwable.
     */
    public SecurityException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new throwable with the specified detail message and cause.
     * @param message the detail message.
     * @param cause a chained exception of type Throwable.
     */
    public SecurityException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new {@link Throwable} with the specified detail message and
     * an error code.
     * @param message a description of the exception.
     * @param errorCode a string specifying the vendor specific error code.
     */
    public SecurityException(String message, String errorCode) {
        super(message, errorCode);
    }

}
