/**
 * OW2 Specifications
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: HintsContext.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi.work;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * This interface specifies the methods a Work instance uses to associate a List of WorkContext instances to be set when the Work
 * instance gets executed by a WorkManager.
 * 
 * A Work instance could optionally implement this interface to indicate to the WorkManager, that the WorkContexts provided by
 * this Work instance through the getWorkContexts method must be used while setting the execution context of the Work instance. If
 * the getWorkContexts method returns an empty List or null, the WorkManager must treat it as if no additional execution contexts
 * are associated with that Work instance.
 * @since 1.6
 * @author Florent Benoit
 */
public class HintsContext implements WorkContext {

    /**
     * Serial Version UID.
     */
    private static final long serialVersionUID = 7956353628297167255L;

    public static final String NAME_HINT = "javax.resource.Name";

    public static final String LONGRUNNING_HINT = "javax.resource.LongRunning";

    protected String description = HintsContext.class.getName();

    protected String name = HintsContext.class.getName();

    Map<String, Serializable> hints;

    /**
     * Constructs a new TransactionContext.
     */
    public HintsContext() {
        this.hints = new HashMap<String, Serializable>();
    }

    /**
     * Get the brief description of the role played by the WorkContext and any other related debugging information.
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the description
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Get the associated name of the WorkContext.
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the name
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    
    /**
     * Set a Hint and a related value. The hintName must be non-Null. Standard HintNames are defined in the Connector
     * specification. Use of "javax.resource." prefixed hintNames are reserved for use by the Connector specification.
     */
    public void setHint(String hintName, Serializable value) {
        hints.put(hintName, value);
    }

    public Map<String, Serializable> getHints() {
        return hints;
    }

}
