/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WorkCompletedException.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi.work;

/**
 * This exception is thrown by a WorkManager to indicate that a submitted
 * Work instance has completed with an exception.<br/>
 *  
 * This could be thrown only after the execution of a Work instance has
 * started (that is, after a thread has been allocated for Work execution).
 * The allocated thread sets up an execution context (if it has been
 * specified), and then calls <code>Work.run()</code>.<br/>
 * 
 * Any exception thrown during execution context setup or during
 * {@link Work} execution (that is, during <code>Work.run()</code>) is
 * chained within this exception.<br/>
 * 
 * An associated error code indicates the nature of the error
 * condition. Possible error codes are <code>WorkException.TX_RECREATE_FAILED</code>
 * , <code>WorkException.TX_CONCURRENT_WORK_DISALLOWED</code> or
 * <code>WorkException.UNDEFINED.</code>
 * @version 1.0 
 * @author Guillaume Sauthier
 */
public class WorkCompletedException extends WorkException {

    /**
     * Serial version UID.
     */
    private static final long serialVersionUID = -229158982387790244L;

    /**
     * Constructs a new instance with null as its detail message.
     */
    public WorkCompletedException() {
        super();
    }

    /**
     * Constructs a new instance with the specified detail message.
     * @param message the detail message.
     */
    public WorkCompletedException(String message) {
        super(message);
    }

    /**
     * Constructs a new throwable with the specified cause.
     * @param cause a chained exception of type Throwable.
     */
    public WorkCompletedException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new throwable with the specified detail message and cause.
     * @param message the detail message.
     * @param cause a chained exception of type Throwable.
     */
    public WorkCompletedException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new {@link Throwable} with the specified detail message and
     * an error code.
     * @param message a description of the exception.
     * @param errorCode a string specifying the vendor specific error code.
     */
    public WorkCompletedException(String message, String errorCode) {
        super(message, errorCode);
    }

}
