/**
 * OW2 Specifications
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WorkContextProvider.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi.work;

import java.io.Serializable;
import java.util.List;

/**
 * This interface specifies the methods a Work instance uses to associate a List of WorkContext instances to be set when the Work
 * instance gets executed by a WorkManager.
 * 
 * A Work instance could optionally implement this interface to indicate to the WorkManager, that the WorkContexts provided by
 * this Work instance through the getWorkContexts method must be used while setting the execution context of the Work instance. If
 * the getWorkContexts method returns an empty List or null, the WorkManager must treat it as if no additional execution contexts
 * are associated with that Work instance.
 * @since 1.6
 * @author Florent Benoit
 */
public interface WorkContextProvider extends Serializable {

    /**
     * Gets an list of WorkContexts that needs to be used by the WorkManager to set up the execution context while executing a Work instance.
     * @return a List of WorkContext instances.
     */
    List<WorkContext> getWorkContexts();
}
