/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WorkEvent.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi.work;

import java.util.EventObject;
 
/**
 * This class models the various events that occur during the processing
 * of a {@link Work} instance.
 * @version 1.0
 * @author Guillaume Sauthier
 */
public class WorkEvent extends EventObject {

    /**
     * Serial version UID.
     */
    private static final long serialVersionUID = -3063612635015047218L;

    /**
     * Indicates Work instance has been accepted.
     */
    public static final int WORK_ACCEPTED = 1;
    
    /**
     * Indicates Work instance has been rejected.
     */
    public static final int WORK_REJECTED = 2;
    
    /**
     * Indicates Work instance has started execution.
     */
    public static final int WORK_STARTED = 3;
    
    /**
     * Indicates Work instance has completed execution.
     */
    public static final int WORK_COMPLETED = 4;

    /**
     * type of this event.
     */
    private int type;

    /**
     * {@link Work} instance which is the cause of the event.
     */
    private Work work;

    /**
     * {@link WorkException}.
     */
    private WorkException exception;

    /**
     * start interval duration.
     */
    private long startDuration;
    
    
    /**
     * @param arg0
     */
    public WorkEvent(Object source,
                     int type,
                     Work work,
                     WorkException exc) {
        this(source, type, work, exc, -1);
    }

    public WorkEvent(Object source,
                     int type,
                     Work work,
                     WorkException exc,
                     long startDuration) {
        super(source);
        this.type = type;
        this.work = work;
        this.exception = exc;
        this.startDuration = startDuration;
    }

    /**
     * Return the type of this event.
     * @return the event type.
     */
    public int getType() {
        return type;
    }

    /**
     * Return the {@link Work} instance which is the cause of the event.
     * @return the {@link Work} instance.
     */
    public Work getWork() {
        return work;
    }

    /**
     * Return the WorkException. The actual {@link WorkException} subtype
     * returned depends on the type of the event.
     * @return a {@link WorkRejectedException} or
     *         a {@link WorkCompletedException}, if any.
     */
    public WorkException getException() {
        return exception;
    }

    /**
     * Return the start interval duration.
     * @return the time elapsed (in milliseconds) since the {@link Work}
     *         was accepted, until the Work execution started. Note, this
     *         does not offer real-time guarantees. It is valid to return -1,
     *         if the actual start interval duration is unknown.
     */
    public long getStartDuration() {
        return startDuration;
    }
    
    
}
