/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: J2eeApplicationObject.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.deploy.model;

import javax.enterprise.deploy.shared.ModuleType;

/**
 * J2eeApplicationObject is an interface that represents a J2EE application
 * (EAR); it maintains a {@link DeployableObject} for each module in the archive.
 * @author Guillaume Sauthier
 */
public interface J2eeApplicationObject extends DeployableObject {

    /**
     * Return the DeployableObject of the specified URI designator.
     * @param uri Describes where to get the module from.
     * @return the DeployableObject describing the j2ee module at this
     *         uri or 'null' if there is not match.
     */
    DeployableObject getDeployableObject(String uri);

    /**
     * Return the all DeployableObjects of the specified type.
     * @param type The type of module to return.
     * @return the list of DeployableObjects describing the j2ee module at this
     *         uri or 'null' if there are no matches.
     */
    DeployableObject[] getDeployableObjects(ModuleType type);

    /**
     * Return the all DeployableObjects in this application.
     * @return the DeployableObject describing the j2ee module at this uri or
     *         'null' if there are no matches.
     */
    DeployableObject[] getDeployableObjects();

    /**
     * Return the list of URIs of the designated module type.
     * @param type The type of module to return.
     * @return the Uris of the contained modules or 'null' if there are no matches.
     */
    String[] getModuleUris(ModuleType type);

    /**
     * Return the list of URIs for all modules in the application.
     * @return the Uris of the contained modules or 'null' if there are no matches.
     */
    String[] getModuleUris();

    /**
     * Return a list of DDBean based upon an XPath; all deployment descriptors of
     * the specified type are searched.
     * @param type The type of deployment descriptor to query.
     * @param xpath An XPath string referring to a location in the deployment descriptor
     * @return The list of DDBeans or 'null' of there are no matches.
     */
    DDBean[] getChildBean(ModuleType type,
                          String xpath);

    /**
     * Return the text value from the XPath; search only the deployment descriptors of
     * the specified type.
     * @param type The type of deployment descriptor to query.
     * @param xpath An xpath string referring to a location in the deployment descriptor
     * @return The text values of this xpath or 'null' if there are no matches.
     */
    String[] getText(ModuleType type,
                     String xpath);

    /**
     * Register a listener for changes in XPath that are related to this deployableObject.
     * @param type The type of deployment descriptor to query.
     * @param xpath The xpath to listen for.
     * @param xpl The listener.
     */
    void addXpathListener(ModuleType type,
                          String xpath,
                          XpathListener xpl);

    /**
     * Unregister the listener for an XPath.
     * @param type The type of deployment descriptor to query.
     * @param xpath the XPath to listen for
     * @param xpl The listener
     */
    void removeXpathListener(ModuleType type,
                             String xpath,
                             XpathListener xpl);
}
