/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DConfigBeanVersionType.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.deploy.shared;

/**
 * Class ActionTypes defines enumeration values for the J2EE DeploymentStatus actions.
 * @author Guillaume Sauthier
 */
public class DConfigBeanVersionType {

    /**
     * J2EE Platform version 1.3.
     */
    public static final DConfigBeanVersionType V1_3 = new DConfigBeanVersionType(0);

    /**
     * J2EE Platform version 1.3.1 THIS CONSTANT SHOULD NEVER BE USED. Use V1_3 instead.
     */
    public static final DConfigBeanVersionType V1_3_1 = new DConfigBeanVersionType(1);

    /**
     * J2EE Platform version 1.4.
     */
    public static final DConfigBeanVersionType V1_4 = new DConfigBeanVersionType(2);

    /**
     * Java EE Platform version 5.
     */
    public static final DConfigBeanVersionType V5 = new DConfigBeanVersionType(3);

    /**
     * Action value.
     */
    private int value;

    /**
     * Supported type table.
     */
    private static final DConfigBeanVersionType[] enumValueTable = {
        V1_3,
        V1_3_1,
        V1_4,
        V5
    };

    /**
     * Supported type's name table.
     */
    private static final String[] stringTable = {
        "J2EE 1.3",
        "J2EE 1.3.1",
        "J2EE 1.4",
        "Java EE 5"
    };

    /**
     * Construct a new enumeration value with the given integer value.
     * @param valueInteger value.
     */
    protected DConfigBeanVersionType(int value) {
        this.value = value;
    }

    /**
     * Returns this enumeration value's integer value.
     * @return the value.
     */
    public int getValue() {
        return this.value;
    }

    /**
     * Returns the string table for class {@link DConfigBeanVersionType}.
     */
    protected String[] getStringTable() {
        return stringTable;
    }

    /**
     * Returns the enumeration value table for class {@link DConfigBeanVersionType}.
     */
    protected DConfigBeanVersionType[] getEnumValueTable() {
        return enumValueTable;
    }

    /**
     * Return an object of the specified value.
     * @param value a designator for the object.
     */
    public static DConfigBeanVersionType getDConfigBeanVersionType(int value) {
        return enumValueTable[value];
    }

    /**
     * Return the string name of this {@link DConfigBeanVersionType} or the integer value if
     * outside the bounds of the table
     */
    public String toString() {
        if (this.value >= 0 && this.value <= stringTable.length) {
            return stringTable[value];
        } else {
            return String.valueOf(value);
        }
    }

    /**
     * Returns the lowest integer value used by this enumeration value's
     * enumeration class.<br/>
     *
     * The default implementation returns 0. If the enumeration class (a
     * subclass of class EnumSyntax) uses integer values starting at other
     * than 0, override this method in the subclass.
     * @return the offset of the lowest enumeration value.
     */
    protected int getOffset() {
        return 0;
    }
}
