/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AuthException.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */
package javax.security.auth.message;

/**
 * A generic authentication exception.
 *
 * @version 1.0
 */
public class AuthException extends javax.security.auth.login.LoginException {
    private static final long serialVersionUID = -1156951780670243758L;

    /**
     * Constructs an AuthException with no detail message. A detail
     * message is a String that describes this particular exception.
     */
    public AuthException() {
        super();
    }

    /**
     * Constructs an AuthException with the specified detail message.
     * A detail message is a String that describes this particular
     * exception.
     *
     * <p />
     *
     * @param msg The detail message.
     */
    public AuthException(String msg) {
        super(msg);
    }
}
