/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ClientAuthContext.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */
package javax.security.auth.message.config;

import javax.security.auth.message.ClientAuth;

/**
 * This ClientAuthContext class encapsulates ClientAuthModules that are used
 * to secure service requests made by a client, and to validate any responses
 * received to those requests. A caller typically uses this class
 * in the following manner:
 *
 * <ol>
 * <li> Retrieve an instance of this class by using
 *	ClientAuthConfig.getAuthContext.</li>
 * <li> Invoke <i>secureRequest</i>.
 *	<br />
 *	ClientAuthContext implementation invokes secureRequest of one or more encapsulated
 *	ClientAuthModules.  Modules might attach credentials to
 *	request (for example, a user name and password),
 *	and/or secure the request (for example, sign and encrypt the request).</li>
 * <li> Send request and receive response.</li>
 * <li> Invoke <i>validateResponse</i>.
 *	<br />
 *	ClientAuthContext implementation invokes validateResponse of
 *      one or more encapsulated
 *	ClientAuthModules. Modules verify or decrypt response as necessary.</li>
 * <li> Invoke <i>cleanSubject</i> method (as necessary)
 *	to clean up any authentication state in Subject.</li>
 * </ol>
 *
 * <p />
 *
 * A ClientAuthContext instance may be used concurrently by multiple
 * callers.
 *
 * <p />
 *
 * Implementations of this interface are responsible for constructing
 * and initializing the encapsulated modules.  The initialization step
 * includes passing the relevant request and response MessagePolicy objects
 * to the encapsulated modules.  The MessagePolicy objects are obtained
 * by the ClientAuthConfig instance used to obtain the ClientAuthContext
 * object.
 * See <code>ClientAuthConfig.getAuthContext</code> for more information.
 *
 * <p />
 *
 * Implementations of this interface are instantiated by their associated
 * configuration object such that they know which modules to invoke, in what
 * order, and how results returned by preceding modules are to influence
 * subsequent module invocations.
 *
 * <p />
 *
 * Calls to the inherited methods of this interface delegate to the
 * corresponding methods of the encapsulated authentication modules.
 *
 * @version 1.0
 * @see ClientAuthConfig
 * @see ClientAuthModule
 */
public interface ClientAuthContext extends ClientAuth {

}
