/**
 * OW2 Specifications
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Handler.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.xml.ws.handler;

/**
 * The {@link Handler} interface is the base interface for JAX-WS handlers.
 * @author Guillaume Sauthier
 * @since JAX-WS 2.0
 */
public interface Handler<C extends MessageContext> {

    /**
     * The <code>handleMessage</code> method is invoked for normal processing of inbound and
     * outbound messages. Refer to the description of the handler framework in
     * the JAX-WS specification for full details.
     * @param context the message context.
     * @return An indication of whether handler processing should continue for the current message
     *         <ul>
     *           <li>Return <code>true</code> to continue processing.</li>
     *           <li>Return <code>false</code> to block processing.</li>
     *         </ul>
     * @throws RuntimeException Causes the JAX-WS runtime to cease handler processing and generate a fault.
     * @throws ProtocolException Causes the JAX-WS runtime to switch to fault message processing.
     */
    boolean handleMessage(C context);

    /**
     * The <code>handleFault</code> method is invoked for fault message processing. Refer to
     * the description of the handler framework in the JAX-WS specification for full details.
     * @param context the message context
     * @return An indication of whether handler fault processing should continue for the current message
     *         <ul>
     *           <li>Return <code>true</code> to continue processing.</li>
     *           <li>Return <code>false</code> to block processing.</li>
     *         </ul>
     * @throws RuntimeException Causes the JAX-WS runtime to cease handler fault processing and dispatch the fault.
     * @throws ProtocolException Causes the JAX-WS runtime to cease handler fault processing and dispatch the fault.
     */
    boolean handleFault(C context);

    /**
     * Called at the conclusion of a message exchange pattern just prior to the JAX-WS runtime
     * disptaching a message, fault or exception. Refer to the description of the handler
     * framework in the JAX-WS specification for full details.
     * @param context the message context
     */
    void close(MessageContext context);
}
