/**
 * OW2 Specifications
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: MessageContext.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.xml.ws.handler;

import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: Guillaume
 * Date: 9 dc. 2008
 * Time: 19:54:25
 * To change this template use File | Settings | File Templates.
 */
public interface MessageContext extends Map<String, Object> {

    static final String MESSAGE_OUTBOUND_PROPERTY = "javax.xml.ws.handler.message.outbound";
    static final String INBOUND_MESSAGE_ATTACHMENTS = "javax.xml.ws.binding.attachments.inbound";
    static final String OUTBOUND_MESSAGE_ATTACHMENTS = "javax.xml.ws.binding.attachments.outbound";
    static final String WSDL_DESCRIPTION = "javax.xml.ws.wsdl.description";
    static final String WSDL_SERVICE = "javax.xml.ws.wsdl.service";
    static final String WSDL_PORT = "javax.xml.ws.wsdl.port";
    static final String WSDL_INTERFACE = "javax.xml.ws.wsdl.interface";
    static final String WSDL_OPERATION = "javax.xml.ws.wsdl.operation";
    static final String HTTP_RESPONSE_CODE = "javax.xml.ws.http.response.code";
    static final String HTTP_REQUEST_HEADERS = "javax.xml.ws.http.request.headers";
    static final String HTTP_RESPONSE_HEADERS = "javax.xml.ws.http.response.headers";
    static final String HTTP_REQUEST_METHOD = "javax.xml.ws.http.request.method";
    static final String SERVLET_REQUEST = "javax.xml.ws.servlet.request";
    static final String SERVLET_RESPONSE = "javax.xml.ws.servlet.response";
    static final String SERVLET_CONTEXT = "javax.xml.ws.servlet.context";
    static final String QUERY_STRING = "javax.xml.ws.http.request.querystring";
    static final String PATH_INFO = "javax.xml.ws.http.request.pathinfo";
    static final String REFERENCE_PARAMETERS = "javax.xml.ws.reference.parameters";

    public static enum Scope {
        APPLICATION, HANDLER
    }

    void setScope(String name, Scope scope);
    Scope getScope(String name);
}
