/**
 * Copyright 2013 ScalAgent Distributed Technologies
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  ---------------------------------------------------------------------
 *  $Id: ConnectionMetaData.java 6349 2013-03-14 10:14:23Z tachker $
 *  ---------------------------------------------------------------------
 */

package javax.jms;

import java.util.Enumeration;

public interface ConnectionMetaData {

  String getJMSVersion() throws JMSException;

  int getJMSMajorVersion() throws JMSException;

  int getJMSMinorVersion() throws JMSException;

  String getJMSProviderName() throws JMSException;

  String getProviderVersion() throws JMSException;

  int getProviderMajorVersion() throws JMSException;

  int getProviderMinorVersion() throws JMSException;

  Enumeration getJMSXPropertyNames() throws JMSException;
}
