/**
 * Copyright 2013 ScalAgent Distributed Technologies
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  ---------------------------------------------------------------------
 *  $Id: QueueRequestor.java 6347 2013-03-13 08:52:02Z tachker $
 *  ---------------------------------------------------------------------
 */

package javax.jms;

public class QueueRequestor {
  private QueueSession session;
  private TemporaryQueue temporaryQueue;
  private QueueSender sender;
  private QueueReceiver receiver;

  public QueueRequestor(QueueSession session, Queue queue) throws JMSException {
    if (queue == null)
      throw new InvalidDestinationException("Invalid queue");
    this.session = session;
    temporaryQueue = session.createTemporaryQueue();
    sender = session.createSender(queue);
    receiver = session.createReceiver(temporaryQueue);
  }

  public Message request(Message message) throws JMSException {
    message.setJMSReplyTo(temporaryQueue);
    sender.send(message);
    return receiver.receive();
  }

  public void close() throws JMSException {
    session.close();
    temporaryQueue.delete();
  }
}
