/**
 * Copyright 2013 ScalAgent Distributed Technologies
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  ---------------------------------------------------------------------
 *  $Id: QueueSession.java 6347 2013-03-13 08:52:02Z tachker $
 *  ---------------------------------------------------------------------
 */

package javax.jms;

public interface QueueSession extends Session {
  
  Queue createQueue(String queueName) throws JMSException;

  QueueReceiver createReceiver(Queue queue) throws JMSException;

  QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException;

  QueueSender createSender(Queue queue) throws JMSException;

  QueueBrowser createBrowser(Queue queue) throws JMSException;

  QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException;

  TemporaryQueue createTemporaryQueue() throws JMSException;
}
