/**
 * OW2 Specifications
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: PessimisticLockScope.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

/**
 * Defines the values of the javax.persistence.lock.scope property for pessimistic locking. This property may be passed as an
 * argument to the methods of the EntityManager, Query, and TypedQuery interfaces that allow lock modes to be specified or used
 * with the NamedQuery annotation.
 * @see <a href="http://jcp.org/en/jsr/detail?id=317">JPA 2.0 specification</a>
 * @author Florent Benoit
 * @since JPA 2.0 version.
 */
public enum PessimisticLockScope {

    /**
     * This value defines the default behavior for pessimistic locking.
     */
    NORMAL,

    /**
     * In addition to the behavior for PessimisticLockScope.NORMAL, element collections and relationships owned by the entity that
     * are contained in join tables will be locked if the javax.persistence.lock.scope property is specified with a value of
     * PessimisticLockScope.EXTENDED.
     */
    EXTENDED
}
