/**
 * OW2 Specifications
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: QueryTimeoutException.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

/**
 * Thrown by the persistence provider when a query times out and only the statement is rolled back. The current transaction, if
 * one is active, will be not be marked for rollback.
 * @see <a href="http://jcp.org/en/jsr/detail?id=317">JPA 2.0 specification</a>
 * @author Florent Benoit
 * @since JPA 2.0 version.
 */
public class QueryTimeoutException extends PersistenceException {

    /**
     * UID for serialization.
     */
    private static final long serialVersionUID = 5061626855006437411L;

    /**
     * Query object.
     */
    //FIXME: not private in the spec !
    Query query = null;
    
    /**
     * Default constructor : builds an exception with an empty message.
     */
    public QueryTimeoutException() {
        super();
    }

    /**
     * Build an exception with the given message.
     * @param message the given message to use.
     */
    public QueryTimeoutException(final String message) {
        super(message);
    }
    
    /**
     * Build an exception with the given entity object.
     * @param entity the given entity to use.
     */
    public QueryTimeoutException(Query query) {
        this();
        this.query = query;
    }

    /**
     * Build an exception with the given exception.
     * @param causedByThrowable the cause of this exception.
     */
    public QueryTimeoutException(final Throwable causedByThrowable) {
        super(causedByThrowable);
    }

    /**
     * Builds an exception with a given message and given exception.
     * @param message the message of this exception.
     * @param causedByThrowable the cause of this exception.
     */
    public QueryTimeoutException(final String message, final Throwable causedByThrowable) {
        super(message, causedByThrowable);
    }
    
    /**
     * Builds an exception with a given message and given exception.
     * @param message the message of this exception.
     * @param causedByThrowable the cause of this exception.
     */
    public QueryTimeoutException(final String message, final Throwable causedByThrowable, Query query) {
        super(message, causedByThrowable);
        this.query = query;
    }
    
    
    /**
     * Returns the query that caused this exception. 
     * @return the query.
     */
    public Query getQuery() {
        return query;
    }


}
