/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: TimeStatistic.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.management.j2ee.statistics;

/**
 * Specifies standard timing measurements.
 * @author Guillaume Sauthier
 */
public interface TimeStatistic extends Statistic {

    /**
     * @return Number of times the operation was invoked
     *         since the beginning of this measurement.
     */
    long getCount(); 
    
    /**
     * @return The maximum amount of time taken to complete
     *         one invocation of this operation since the
     *         beginning of this measurement.
     */
    long getMaxTime();
    
    /**
     * @return The minimum amount of time taken to complete
     *         one invocation of this operation since the
     *         beginning of this measurement.
     */
    long getMinTime();
    
    /**
     * @return This is the sum total of time taken to complete
     *         every invocation of this operation since the
     *         beginning of this measurement. Dividing totalTime
     *         by count will give you the average execution time
     *         for this operation.
     */
    long getTotalTime();
}
