/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: HandlerChain.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.jws;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Associates the Web Service with an externally defined handler
 * chain. This annotation is typically used in scenarios where
 * embedding the handler configuration directly in the Java source
 * is not appropriate; for example, where the handler configuration
 * needs to be shared across multiple Web Services, or where the handler
 * chain consists of handlers for multiple transports. It is an error
 * to combine this annotation with the @SOAPMessageHandlers annotation.
 * @author Guillaume Sauthier
 */
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD})
public @interface HandlerChain {

    /**
     * Location of the handler chain file.<br/>
     * The location supports 2 formats:
     * <ol>
     *   <li>An absolute java.net.URL in externalForm (ex:
     *   <code>http://myhandlers.foo.com/handlerfile1.xml</code>).</li>
     *   <li>A relative path from the source file or class file
     *   (ex: <code>bar/handlerfile1.xml</code>).</li>
     * </ol>
     */
    String file();

    /**
     * Name of the handler chain in the configuration file.
     * @deprecated As of JSR-181 2.0 with no replacement.
     */
    @Deprecated
    String name() default "";
}
