/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: WebResult.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.jws;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Customizes the mapping of the return value to a WSDL part and XML element.
 * @author Guillaume Sauthier
 */
@Retention(value=RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface WebResult {

    /**
     * If true, the result is pulled from a message header rather
     * than the message body.
     * @since 2.0
     */
    boolean header() default false;

    /**
     * Name of return value.<br/>
     *
     * If the operation is rpc style and @WebResult.partName has not been
     * specified, this is the name of the wsdl:part representing the
     * return value.<br/>
     *
     * If the operation is document style or the return value maps to a
     * header, this is the local name of the XML element representing
     * the return value.
     */
    String name() default "";

    /**
     * The name of the wsdl:part representing this return value.<br/>
     *
     * This is only used if the operation is rpc style, or if the
     * operation is document style and the parameter style is BARE.
     *
     * @since 2.0
     */
    String partName() default "";

    /**
     * The XML namespace for the return value.<br/>
     *
     * Only used if the operation is document style or the return value
     * maps to a header. If the target namespace is set to ??, this
     * represents the empty namespace.
     */
    String targetNamespace() default "";

}
