/**
 * OW2 Specifications
 * Copyright (C) 2010-2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ValidationProviderResolverHolder.java 6220 2012-04-02 08:57:39Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.spec.ee.validation;

import javax.validation.ValidationProviderResolver;

public class ValidationProviderResolverHolder {

    /**
     * Existing validation provider.
     */
    private static ValidationProviderResolver validationProviderResolver= null;
    
    public static void setValidationProviderResolver(ValidationProviderResolver validationProviderResolver) {
        ValidationProviderResolverHolder.validationProviderResolver = validationProviderResolver;
    }
    
    public static ValidationProviderResolver getValidationProviderResolver() {
        if (validationProviderResolver == null) {
            // Return a default validation provider by default
            return new ValidationProviderResolverImpl();
        }
        return validationProviderResolver;
    }
}
