package org.ow2.weblab.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import org.ow2.weblab.core.extended.exception.WebLabCheckedException;

public class ContentUtil {
	public static boolean equals(File one, File another) throws WebLabCheckedException {
		if (one == null || another == null)
			return false;
		if (one.length() != another.length())
			return false;
		if (ContentUtil.SHA1(one).compareTo(ContentUtil.SHA1(another)) != 0)
			return false;
		return true;
	}
	
	public static boolean equals(byte[] one, byte[] another) throws WebLabCheckedException {
		if (one == null || another == null)
			return false;
		if (one.length != another.length)
			return false;
		if (ContentUtil.SHA1(one).compareTo(ContentUtil.SHA1(another)) != 0)
			return false;
		return true;
	}

	public static String SHA1(File in) throws WebLabCheckedException {
		try {
			MessageDigest md = MessageDigest.getInstance("SHA-1");
			FileInputStream fis = new FileInputStream(in);
			byte[] sha1hash = new byte[40];
			byte[] dataBytes = new byte[1024];
			int nread = 0;
			while ((nread = fis.read(dataBytes)) != -1) {
				md.update(dataBytes, 0, nread);
			}
			sha1hash = md.digest();

			String hash = ContentUtil.convertToHex(sha1hash);

			return hash;
		} catch (NoSuchAlgorithmException e) {
			throw new WebLabCheckedException("Cannot load SHA1 algorithm.",e);
		} catch (FileNotFoundException e) {
			throw new WebLabCheckedException("Cannot load file ["+in+"] for SHA1 computation.",e);
		} catch (IOException e) {
			throw new WebLabCheckedException("Cannot access content of file ["+in+"] for SHA1 computation.",e);
		}
	}

	public static String SHA1(byte[] dataBytes) throws WebLabCheckedException {
		try {
			MessageDigest md = MessageDigest.getInstance("SHA-1");
			byte[] sha1hash = new byte[40];
			md.update(dataBytes, 0, dataBytes.length);
			sha1hash = md.digest();
			String hash = ContentUtil.convertToHex(sha1hash);
			return hash;
		} catch (NoSuchAlgorithmException e) {
			throw new WebLabCheckedException("Cannot load SHA1 algorithm.",e);
		}
	}

	public static String convertToHex(byte[] data) {
		StringBuffer buf = new StringBuffer();
		for (int i = 0; i < data.length; i++) {
			int halfbyte = (data[i] >>> 4) & 0x0F;
			int two_halfs = 0;
			do {
				if ((0 <= halfbyte) && (halfbyte <= 9))
					buf.append((char) ('0' + halfbyte));
				else
					buf.append((char) ('a' + (halfbyte - 10)));
				halfbyte = data[i] & 0x0F;
			} while (two_halfs++ < 1);
		}
		return buf.toString();
	}
}
