/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.content.binary;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.content.FolderContentManager;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;

/**
 * @deprecated this class is obsolete. Use FolderContentManager directly.
 */
public class BinaryFolderContentManager extends FolderContentManager {

	static Map<String, BinaryFolderContentManager> map = new HashMap<String, BinaryFolderContentManager>();

	protected BinaryFolderContentManager(final String folderPath) throws WebLabUncheckedException {
		super(folderPath);
	}

	/**
	 * @param file
	 *            Input file
	 * @param newFile
	 *            Output file
	 * @throws WebLabCheckedException
	 *             If an IOException occurs.
	 */
	protected void copyAFile(final File file, final File newFile) throws WebLabCheckedException {
		byte[] tab = new byte[FolderContentManager.BUFFER_SIZE];
		try {
			BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
			try {
				BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(newFile, true));
				try {
					int readed = bis.read(tab);
					while (readed != -1) {
						bos.write(tab, 0, readed);
						readed = bis.read(tab);
					}
				} finally {
					try {
						bos.close();
					} catch (final IOException ioe) {
						LogFactory.getLog(this.getClass()).warn("Unable to close stream.", ioe);
					}
				}
			} finally {
				try {
					bis.close();
				} catch (final IOException ioe) {
					LogFactory.getLog(this.getClass()).warn("Unable to close stream.", ioe);
				}
			}
		} catch (final IOException ioe) {
			throw new WebLabCheckedException("Unable to copy file.", ioe);
		}
	}

	/**
	 * Add new file to the content manager (copy it to the internal repository)
	 * 
	 * @param file
	 *            file to copy
	 * @param uri
	 *            identify the future content
	 * @throws WebLabCheckedException
	 */
	public void saveFile(final File file, final String uri) throws WebLabCheckedException {
		/*
		 * create the file and its folders
		 */
		File newFile = this.getFileFromWLRi(uri);
		if (!newFile.getParentFile().exists() && !newFile.getParentFile().mkdirs()) {
			LogFactory.getLog(this.getClass()).warn("Unable to create parent directory.");
		}
		this.copyAFile(file, newFile);
	}

	/**
	 * @param folderPath
	 *            The path to the folder.
	 * @return The BinaryFolderContentManager
	 * @throws WebLabUncheckedException
	 */
	public static BinaryFolderContentManager getInstance(String folderPath) throws WebLabUncheckedException {
		BinaryFolderContentManager binaryFolderContentManager = BinaryFolderContentManager.map.get(folderPath);
		if (binaryFolderContentManager == null) {
			binaryFolderContentManager = new BinaryFolderContentManager(folderPath);
			BinaryFolderContentManager.map.put(folderPath, binaryFolderContentManager);
		}
		return binaryFolderContentManager;
	}

	/**
	 * @return The BinaryFolderContentManager
	 * @throws WebLabUncheckedException
	 */
	public static BinaryFolderContentManager getInstance() throws WebLabUncheckedException {
		return BinaryFolderContentManager.getInstance(FolderContentManager.getPropertyValue(FolderContentManager.CONTENT_PROPERTIES, "binarycontentpath",
				"binarycontent"));
	}

}
