/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.content;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.properties.PropertiesLoader;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.processing.WProcessingAnnotator;
import org.ow2.weblab.rdf.Value;

public abstract class ContentManager {
    public static final String CONTENT_MANAGER_PROPERTIES_FILE = "contentManager.properties";
    public static final String CONTENT_MANAGER_IMPLEMENTATION = "content.manager.implementation";
    public static int BUFFER_SIZE = 1024;
    protected static Log logger = LogFactory.getLog(ContentManager.class);
    protected static ContentManager instance;
    private static Boolean loaded;

    protected abstract URI saveContent(InputStream var1, Resource var2) throws WebLabCheckedException;

    protected abstract File readContent(Resource var1, URI var2) throws WebLabCheckedException;

    public URI saveNativeContent(InputStream content, Resource res) throws WebLabCheckedException {
        URI destURI = this.saveContent(content, res);
        WProcessingAnnotator wpa = new WProcessingAnnotator(res);
        wpa.writeNativeContent(destURI);
        return destURI;
    }

    public URI saveNormalisedContent(InputStream content, Resource res) throws WebLabCheckedException {
        URI destURI = this.saveContent(content, res);
        WProcessingAnnotator wpa = new WProcessingAnnotator(res);
        wpa.writeNormalisedContent(destURI);
        return destURI;
    }

    public File readNativeContent(Resource res) throws WebLabCheckedException {
        WProcessingAnnotator wpa = new WProcessingAnnotator(res);
        Value values = wpa.readNativeContent();
        if (values == null || values.size() == 0) {
            throw new WebLabCheckedException("There is no native content defined on this resource [" + res.getUri() + "]");
        }
        if (values.size() > 1) {
            throw new WebLabCheckedException("There is multiple native content defined on this resource [" + res.getUri() + "]:" + values);
        }
        URI uri = (URI)values.getValues().get(0);
        return this.readContent(res, uri);
    }

    public File readNormalisedContent(Resource res) throws WebLabCheckedException {
        WProcessingAnnotator wpa = new WProcessingAnnotator(res);
        Value values = wpa.readNormalisedContent();
        if (values == null || values.size() == 0) {
            throw new WebLabCheckedException("There is no native content defined on this resource [" + res.getUri() + "]");
        }
        if (values.size() > 1) {
            throw new WebLabCheckedException("There is multiple native content defined on this resource [" + res.getUri() + "]:" + values);
        }
        URI uri = (URI)values.getValues().get(0);
        return this.readContent(res, uri);
    }

    protected static String getImplementationName() {
        if (loaded.booleanValue()) {
            return instance.getClass().getName();
        }
        return ContentManager.getPropertyValue(CONTENT_MANAGER_IMPLEMENTATION, "org.ow2.weblab.content.WebDAVContentManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ContentManager getInstance(String implClass) {
        try {
            Boolean bl = loaded;
            synchronized (bl) {
                if (!loaded.booleanValue() || instance == null || instance.getClass().getName().compareTo(implClass) != 0) {
                    Class<?> theClass = Class.forName(implClass);
                    instance = (ContentManager)theClass.newInstance();
                    loaded = true;
                }
            }
            return instance;
        }
        catch (ClassNotFoundException e) {
            throw new WebLabUncheckedException("Cannot found the class [" + implClass + "] to instanciate the content manager", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new WebLabUncheckedException("Cannot instanciate [" + implClass + "] as content manager");
        }
        catch (IllegalAccessException e) {
            throw new WebLabUncheckedException("Error while constructing a [" + implClass + "] as content manager");
        }
    }

    public static ContentManager getInstance() {
        return ContentManager.getInstance(ContentManager.getImplementationName());
    }

    protected static String getPropertyValue(String propertyValue, String defaultValue) {
        String value;
        HashMap map;
        try {
            map = PropertiesLoader.loadProperties((String)CONTENT_MANAGER_PROPERTIES_FILE);
        }
        catch (WebLabUncheckedException wlue) {
            map = new HashMap(0);
        }
        if (map.containsKey(propertyValue)) {
            value = (String)map.get(propertyValue);
        } else {
            logger.warn((Object)("Unable to load '" + propertyValue + "' from file '" + CONTENT_MANAGER_PROPERTIES_FILE + "'."));
            value = defaultValue;
        }
        logger.debug((Object)("Loaded : '" + value + "' as [" + propertyValue + "]."));
        return value;
    }

    protected static void writeStream(InputStream is, OutputStream os) throws IOException {
        int numRead;
        byte[] buf = new byte[BUFFER_SIZE];
        while ((numRead = is.read(buf)) >= 0) {
            os.write(buf, 0, numRead);
        }
        is.close();
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyFile(File file, File newFile) throws WebLabCheckedException {
        byte[] tab = new byte[BUFFER_SIZE];
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            try {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(newFile, true));
                try {
                    int readed = bis.read(tab);
                    while (readed != -1) {
                        bos.write(tab, 0, readed);
                        readed = bis.read(tab);
                    }
                }
                finally {
                    try {
                        bos.close();
                    }
                    catch (IOException ioe) {
                        logger.warn((Object)"Unable to close stream.", (Throwable)ioe);
                    }
                }
            }
            finally {
                try {
                    bis.close();
                }
                catch (IOException ioe) {
                    logger.warn((Object)"Unable to close stream.", (Throwable)ioe);
                }
            }
        }
        catch (IOException ioe) {
            throw new WebLabCheckedException("Unable to copy file.", (Throwable)ioe);
        }
    }

    static {
        loaded = false;
    }
}

