/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;

public class ContentUtil {
    public static boolean equals(File one, File another) throws WebLabCheckedException {
        if (one == null || another == null) {
            return false;
        }
        if (one.length() != another.length()) {
            return false;
        }
        return ContentUtil.SHA1(one).compareTo(ContentUtil.SHA1(another)) == 0;
    }

    public static boolean equals(byte[] one, byte[] another) throws WebLabCheckedException {
        if (one == null || another == null) {
            return false;
        }
        if (one.length != another.length) {
            return false;
        }
        return ContentUtil.SHA1(one).compareTo(ContentUtil.SHA1(another)) == 0;
    }

    public static String SHA1(File in) throws WebLabCheckedException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            FileInputStream fis = new FileInputStream(in);
            byte[] sha1hash = new byte[40];
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            sha1hash = md.digest();
            String hash = ContentUtil.convertToHex(sha1hash);
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new WebLabCheckedException("Cannot load SHA1 algorithm.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new WebLabCheckedException("Cannot load file [" + in + "] for SHA1 computation.", (Throwable)e);
        }
        catch (IOException e) {
            throw new WebLabCheckedException("Cannot access content of file [" + in + "] for SHA1 computation.", (Throwable)e);
        }
    }

    public static String SHA1(byte[] dataBytes) throws WebLabCheckedException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] sha1hash = new byte[40];
            md.update(dataBytes, 0, dataBytes.length);
            sha1hash = md.digest();
            String hash = ContentUtil.convertToHex(sha1hash);
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new WebLabCheckedException("Cannot load SHA1 algorithm.", (Throwable)e);
        }
    }

    public static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (halfbyte >= 0 && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
            ++i;
        }
        return buf.toString();
    }
}

