/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.content;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.webdav.client.methods.PutMethod;
import org.ow2.weblab.content.URIScheme;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.properties.PropertiesLoader;
import org.ow2.weblab.core.extended.uri.WebLabRI;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.processing.WProcessingAnnotator;
import org.ow2.weblab.rdf.Value;

public class FolderContentManager {
    public static final String CONTENT_PROPERTIES = "contentManager.properties";
    public static final String CONTENT_PATH = "content.path";
    public static final String WEBDAV_HOST = "webdav.host";
    public static final String WEBDAV_PASSWORD = "webdav.password";
    public static final String WEBDAV_USERNAME = "webdav.username";
    public static int BUFFER_SIZE = 1024;
    public static Log logger = LogFactory.getLog(FolderContentManager.class);
    protected String propertyKey = "folderpath";
    protected String propertyFileName = "content.properties";
    protected File folder = new File(FolderContentManager.getPropertyValue("contentManager.properties", "content.path", ""));
    protected String webdavHost = FolderContentManager.getPropertyValue("contentManager.properties", "webdav.host", "");
    protected String webdavUserName;
    protected String webdavPassword;
    protected HttpClient client;
    public static final String SIMPLE_RESOURCE_RDF_HELPER = "org.weblab_project.core.helper.impl.JenaSingleResourceHelper";

    protected FolderContentManager() throws WebLabUncheckedException {
        if (!this.webdavHost.endsWith("/")) {
            this.webdavHost = this.webdavHost + '/';
        }
        this.webdavUserName = FolderContentManager.getPropertyValue(CONTENT_PROPERTIES, WEBDAV_USERNAME, "");
        this.webdavPassword = FolderContentManager.getPropertyValue(CONTENT_PROPERTIES, WEBDAV_PASSWORD, "");
        if (this.webdavHost.length() > 1) {
            logger.debug((Object)("Webdav is configured for: " + this.webdavUserName + "@" + this.webdavHost));
        }
    }

    protected FolderContentManager(String folderPath) throws WebLabUncheckedException {
        this();
        this.folder = new File(folderPath);
        if (!FolderContentManager.checkFolder(this.folder)) {
            throw new WebLabUncheckedException("Folder '" + this.folder.getAbsolutePath() + "' is not a valid folder path");
        }
        logger.debug((Object)("Content provider uses folder : " + this.folder.getAbsolutePath()));
    }

    private void initWebDAVClient() {
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost(this.webdavHost);
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        int maxHostConnections = 20;
        params.setMaxConnectionsPerHost(hostConfig, maxHostConnections);
        connectionManager.setParams(params);
        this.client = new HttpClient((HttpConnectionManager)connectionManager);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials("userId", "pw");
        this.client.getState().setCredentials(AuthScope.ANY, (Credentials)creds);
        this.client.setHostConfiguration(hostConfig);
    }

    protected static boolean checkFolder(File folder) {
        if (folder.exists()) {
            return folder.isDirectory();
        }
        return folder.mkdirs();
    }

    public void saveNativeContent(File content, Resource res) throws WebLabCheckedException {
        this.saveNativeContentOnWebDAV(content, res);
    }

    public void saveNormalisedContent(File content, Resource res) throws WebLabCheckedException {
        this.saveNativeContentOnWebDAV(content, res);
    }

    public void saveNativeContentOnWebDAV(File content, Resource res) throws WebLabCheckedException {
        logger.info((Object)("Saving content on WebDAV host [" + this.webdavHost + "]"));
        if (this.client == null) {
            this.initWebDAVClient();
        }
        try {
            URI contentURI = new URI(this.webdavHost + content.toString().hashCode());
            PutMethod put = new PutMethod("http://localhost:8080/repository/default/test.pdf");
            put.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new FileInputStream(content)));
            this.client.executeMethod((HttpMethod)put);
            WProcessingAnnotator annot = new WProcessingAnnotator(res);
            annot.writeNativeContent(contentURI);
        }
        catch (URISyntaxException e) {
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getFileFromWLRi(String uri) {
        return this.getFileFromWLRi(new WebLabRI(uri));
    }

    protected File getFileFromWLRi(WebLabRI uri) {
        logger.debug((Object)("File path : " + this.folder.getAbsolutePath() + "/" + uri.toString().hashCode()));
        File newFile = new File(this.folder.getAbsolutePath() + "/" + uri.toString().hashCode());
        if (!newFile.getParentFile().exists() && !newFile.getParentFile().mkdirs()) {
            logger.warn((Object)"Unable to create file. It may throw exception later.");
        }
        return newFile;
    }

    public File getNativeFileFromResource(Resource res) throws WebLabCheckedException {
        WProcessingAnnotator wpa = new WProcessingAnnotator(res);
        return this.getFileFromResourceAndPredicate(res, (Value<URI>)wpa.readNativeContent(), "");
    }

    public File getNormalisedFileFromResource(Resource res) throws WebLabCheckedException {
        WProcessingAnnotator wpa = new WProcessingAnnotator(res);
        return this.getFileFromResourceAndPredicate(res, (Value<URI>)wpa.readNormalisedContent(), "http://weblab.ow2.org/core/1.2/ontology/processing#hasNormalisedContent");
    }

    protected File getFileFromResourceAndPredicate(Resource res, Value<URI> values, String pred) throws WebLabCheckedException {
        File file = null;
        if (values == null || values.size() <= 0) {
            throw new WebLabCheckedException("No statement having '" + pred + "' as predicate found on resource '" + res.getUri() + "'.");
        }
        if (values.size() == 1) {
            URI contentURI = (URI)values.firstTypedValue();
            String sheme = contentURI.getScheme();
            switch (URIScheme.valueOf(sheme)) {
                case weblab: {
                    file = this.getLocalFileFromURI(contentURI);
                    break;
                }
                case file: {
                    file = this.getLocalFile(contentURI);
                    break;
                }
                case ftp: {
                    throw new WebLabUncheckedException("Access to fTP content is not yet implemented.");
                }
                case http: {
                    file = this.getFileFromHttp(contentURI);
                }
            }
        } else {
            try {
                file = this.getFileFromWLRi(values.toString());
            }
            catch (Exception e) {
                throw new WebLabCheckedException("Unable to retrieve file from predicate '" + pred + "' and resource '" + res.getUri() + "'.", (Throwable)e);
            }
            logger.warn((Object)("Multiple statements having '" + pred + "' as predicate " + "found on resource '" + res.getUri() + "'. The fist one was used."));
            logger.debug((Object)values.toString());
        }
        if (!(file == null || file.exists() && file.isFile() && file.canRead())) {
            throw new WebLabCheckedException("Unable to retrieve file from predicate '" + pred + "' and resource '" + res.getUri() + "'; File '" + file.getPath() + "' does not exist, is not a file or is not accessible.");
        }
        return file;
    }

    private File getFileFromHttp(URI contentURI) {
        if (this.webdavHost.contains(contentURI.getHost())) {
            return this.getFileFromWebDav(contentURI);
        }
        throw new WebLabUncheckedException("Access to simple HTTP content is not yet implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFileFromWebDav(URI contentURI) {
        logger.info((Object)("Getting content from WebDAV host [" + this.webdavHost + "]"));
        if (this.client == null) {
            this.initWebDAVClient();
        }
        File out = null;
        OutputStream stream = null;
        try {
            out = File.createTempFile("webDAV", "", this.folder);
            GetMethod get = new GetMethod(contentURI.toString());
            this.client.executeMethod((HttpMethod)get);
            InputStream inStream = get.getResponseBodyAsStream();
            BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(out));
            FolderContentManager.writeStream(inStream, outStream);
            inStream.close();
            ((OutputStream)outStream).close();
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return out;
    }

    private File getLocalFile(URI contentURI) throws WebLabCheckedException {
        File file = new File(contentURI);
        if (!file.exists()) {
            throw new WebLabCheckedException("The content file [" + contentURI + "] does not exists.");
        }
        if (!file.canRead()) {
            throw new WebLabCheckedException("The content file [" + contentURI + "] is not readable.");
        }
        return file;
    }

    private File getLocalFileFromURI(URI contentURI) throws WebLabCheckedException {
        try {
            return this.getFileFromWLRi(contentURI.toString());
        }
        catch (Exception e) {
            throw new WebLabCheckedException("Unable to retrieve file localtion from content URI [" + contentURI + "].", (Throwable)e);
        }
    }

    protected static String getPropertyValue(String propertyPath, String propertyValue, String defaultValue) {
        String value;
        HashMap map;
        try {
            map = PropertiesLoader.loadProperties((String)propertyPath);
        }
        catch (WebLabUncheckedException wlue) {
            map = new HashMap(0);
        }
        if (map.containsKey(propertyValue)) {
            value = (String)map.get(propertyValue);
        } else {
            LogFactory.getLog(FolderContentManager.class).warn((Object)("Unable to load '" + propertyValue + "' from file '" + propertyPath + "'."));
            value = defaultValue;
        }
        LogFactory.getLog(FolderContentManager.class).debug((Object)("Loaded : '" + value + "' as [" + propertyValue + "]."));
        return value;
    }

    public File getFolder() {
        return this.folder;
    }

    public void setFolder(File folder) {
        this.folder = folder;
    }

    public static void writeStream(InputStream is, OutputStream os) throws IOException {
        int numRead;
        byte[] buf = new byte[BUFFER_SIZE];
        while ((numRead = is.read(buf)) >= 0) {
            os.write(buf, 0, numRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File newFile) throws WebLabCheckedException {
        byte[] tab = new byte[BUFFER_SIZE];
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            try {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(newFile, true));
                try {
                    int readed = bis.read(tab);
                    while (readed != -1) {
                        bos.write(tab, 0, readed);
                        readed = bis.read(tab);
                    }
                }
                finally {
                    try {
                        bos.close();
                    }
                    catch (IOException ioe) {
                        logger.warn((Object)"Unable to close stream.", (Throwable)ioe);
                    }
                }
            }
            finally {
                try {
                    bis.close();
                }
                catch (IOException ioe) {
                    logger.warn((Object)"Unable to close stream.", (Throwable)ioe);
                }
            }
        }
        catch (IOException ioe) {
            throw new WebLabCheckedException("Unable to copy file.", (Throwable)ioe);
        }
    }
}

