/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.content;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.client.methods.PutMethod;
import org.ow2.weblab.content.ContentManager;
import org.ow2.weblab.content.ContentUtil;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.model.Resource;

public class WebDAVContentManager
extends ContentManager {
    public static Log logger = LogFactory.getLog(WebDAVContentManager.class);
    public static final String WEBDAV_TMP_FOLDER_PATH = "webdav.tmpFolder";
    public static final String WEBDAV_HOST = "webdav.host";
    public static final String WEBDAV_TIMEOUT = "webdav.timeout";
    public static final String WEBDAV_MAXHOSTCONNECTIONS = "webdav.maxHostConnections";
    public static final String WEBDAV_PASSWORD = "webdav.password";
    public static final String WEBDAV_USERNAME = "webdav.username";
    private String webdavTmpFolder;
    private String webdavHost;
    private int webdavTimeOut;
    private int webdavMaxHostConnections;
    private String webdavUserName;
    private String webdavPassword;
    private File tmpFolder;

    protected WebDAVContentManager() {
        this.setWebdavTmpFolder(ContentManager.getPropertyValue(WEBDAV_TMP_FOLDER_PATH, "/tmp"));
        logger.info((Object)("webdav.tmpFolder=" + this.webdavTmpFolder));
        this.webdavHost = ContentManager.getPropertyValue(WEBDAV_HOST, null);
        if (!this.webdavHost.endsWith("/")) {
            this.webdavHost = String.valueOf(this.webdavHost) + '/';
        }
        logger.info((Object)("webdav.host=" + this.webdavHost));
        this.webdavTimeOut = Integer.parseInt(ContentManager.getPropertyValue(WEBDAV_TIMEOUT, "30000"));
        this.webdavMaxHostConnections = Integer.parseInt(ContentManager.getPropertyValue(WEBDAV_MAXHOSTCONNECTIONS, "20"));
        this.webdavUserName = ContentManager.getPropertyValue(WEBDAV_PASSWORD, null);
        this.webdavPassword = ContentManager.getPropertyValue(WEBDAV_USERNAME, null);
        logger.info((Object)("webdav.username=" + this.webdavUserName + " and " + WEBDAV_PASSWORD + " is set."));
    }

    private HttpClient initWebDAVClient() throws WebLabCheckedException {
        if (this.webdavTmpFolder == null) {
            throw new WebLabCheckedException("Cannot initiate WebDAV host: tmpFolder value is null");
        }
        if (this.webdavHost == null) {
            throw new WebLabCheckedException("Cannot initiate WebDAV host: host value is null");
        }
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost(this.webdavHost);
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setMaxConnectionsPerHost(hostConfig, this.webdavMaxHostConnections);
        params.setSoTimeout(this.webdavTimeOut);
        connectionManager.setParams(params);
        HttpClient clnt = new HttpClient((HttpConnectionManager)connectionManager);
        if (this.webdavUserName == null || this.webdavPassword == null) {
            throw new WebLabCheckedException("Cannot initiate WebDAV host: user and/or password value is null");
        }
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.webdavUserName, this.webdavPassword);
        clnt.getState().setCredentials(AuthScope.ANY, (Credentials)creds);
        clnt.setHostConfiguration(hostConfig);
        return clnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected URI saveContent(InputStream content, Resource res) throws WebLabCheckedException {
        logger.debug((Object)("Saving content on WebDAV host [" + this.webdavHost + "]"));
        HttpClient client = null;
        WebDAVContentManager webDAVContentManager = this;
        synchronized (webDAVContentManager) {
            client = this.initWebDAVClient();
        }
        try {
            URI destURI = new URI(String.valueOf(this.webdavHost) + ContentUtil.SHA1(res.getUri().getBytes()) + '@' + System.currentTimeMillis());
            PutMethod put = new PutMethod(destURI.toString());
            put.setRequestEntity((RequestEntity)new InputStreamRequestEntity(content));
            WebDAVContentManager webDAVContentManager2 = this;
            synchronized (webDAVContentManager2) {
                client.executeMethod((HttpMethod)put);
            }
            put.checkSuccess();
            return destURI;
        }
        catch (FileNotFoundException e) {
            throw new WebLabCheckedException("Cannot save content: file [" + content + "] is not found.", (Throwable)e);
        }
        catch (HttpException e) {
            throw new WebLabCheckedException("Cannot save content: PUT method failure for resource [" + res.getUri() + "] on WebDAV server [" + this.webdavHost + "]", (Throwable)e);
        }
        catch (IOException e) {
            throw new WebLabCheckedException("Cannot save content: I/O error while writing content for resource [" + res.getUri() + "] on WebDAV server [" + this.webdavHost + "]", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new WebLabCheckedException("Cannot save content: [" + this.webdavHost + res.hashCode() + "] is an invalid URI.", (Throwable)e);
        }
        catch (DavException e) {
            throw new WebLabCheckedException("WebDAV error while saving [" + this.webdavHost + res.hashCode() + "].", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected File readContent(Resource res, URI destUri) throws WebLabCheckedException {
        if (!destUri.toString().contains(this.webdavHost)) {
            throw new WebLabCheckedException("Cannot read content [" + destUri + "]. The host is unknown.");
        }
        logger.debug((Object)("Getting content [" + destUri + "] from WebDAV."));
        HttpClient client = null;
        WebDAVContentManager webDAVContentManager = this;
        synchronized (webDAVContentManager) {
            client = this.initWebDAVClient();
        }
        File out = null;
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            try {
                out = File.createTempFile("webDAV", ".content", this.tmpFolder);
                GetMethod get = new GetMethod(destUri.toString());
                WebDAVContentManager webDAVContentManager2 = this;
                synchronized (webDAVContentManager2) {
                    client.executeMethod((HttpMethod)get);
                }
                if (get.getStatusCode() != 200) {
                    throw new WebLabCheckedException("Cannot read content: GET method failure for content [" + destUri + "] : " + get.getStatusCode() + " '" + get.getStatusText() + "'");
                }
                inStream = get.getResponseBodyAsStream();
                outStream = new BufferedOutputStream(new FileOutputStream(out));
                WebDAVContentManager.writeStream(inStream, outStream);
            }
            catch (HttpException e) {
                throw new WebLabCheckedException("Cannot read content: GET method failure for content [" + destUri + "] on WebDAV server [" + this.webdavHost + "]", (Throwable)e);
            }
            catch (IOException e) {
                throw new WebLabCheckedException("Cannot read content: I/O error while copying [" + destUri + "] from WebDAV server [" + this.webdavHost + "] to local File [" + out + "].", (Throwable)e);
            }
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                throw new WebLabCheckedException("Cannot read content: I/O error while closing stream after reading content on WebDAV.", (Throwable)e);
            }
        }
        return out;
    }

    public String getWebdavTmpFolder() {
        return this.webdavTmpFolder;
    }

    protected void setWebdavTmpFolder(String webdavTmpFolder) {
        this.webdavTmpFolder = webdavTmpFolder;
        logger.info((Object)("webdav.tmpFolder=" + this.webdavTmpFolder));
        this.tmpFolder = new File(this.webdavTmpFolder);
        if (!this.tmpFolder.exists()) {
            this.tmpFolder.mkdirs();
        }
        if (!this.tmpFolder.exists()) {
            throw new WebLabUncheckedException("Content folder [" + this.tmpFolder + "] does not exists or is not readable.");
        }
        if (!this.tmpFolder.canWrite()) {
            throw new WebLabUncheckedException("Cannot write in content folder [" + this.tmpFolder + "].");
        }
        if (this.tmpFolder.isFile()) {
            throw new WebLabUncheckedException("Content folder [" + this.tmpFolder + "] is a File instead of a directory.");
        }
    }

    public String getWebdavHost() {
        return this.webdavHost;
    }

    protected void setWebdavHost(String webdavHost) {
        this.webdavHost = webdavHost;
    }

    public int getWebdavTimeOut() {
        return this.webdavTimeOut;
    }

    protected void setWebdavTimeOut(int webdavTimeOut) {
        this.webdavTimeOut = webdavTimeOut;
    }

    public int getWebdavMaxHostConnections() {
        return this.webdavMaxHostConnections;
    }

    protected void setWebdavMaxHostConnections(int webdavMaxHostConnections) {
        this.webdavMaxHostConnections = webdavMaxHostConnections;
    }

    public String getWebdavUserName() {
        return this.webdavUserName;
    }

    protected void setWebdavUserName(String webdavUserName) {
        this.webdavUserName = webdavUserName;
    }

    public String getWebdavPassword() {
        return this.webdavPassword;
    }

    protected void setWebdavPassword(String webdavPassword) {
        this.webdavPassword = webdavPassword;
    }
}

