/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.content.binary;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.content.FolderContentManager;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;

public class BinaryFolderContentManager
extends FolderContentManager {
    static Map<String, BinaryFolderContentManager> map = new HashMap<String, BinaryFolderContentManager>();

    protected BinaryFolderContentManager(String folderPath) throws WebLabUncheckedException {
        super(folderPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyAFile(File file, File newFile) throws WebLabCheckedException {
        byte[] tab = new byte[FolderContentManager.BUFFER_SIZE];
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            try {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(newFile, true));
                try {
                    int readed = bis.read(tab);
                    while (readed != -1) {
                        bos.write(tab, 0, readed);
                        readed = bis.read(tab);
                    }
                }
                finally {
                    try {
                        bos.close();
                    }
                    catch (IOException ioe) {
                        LogFactory.getLog(this.getClass()).warn((Object)"Unable to close stream.", (Throwable)ioe);
                    }
                }
            }
            finally {
                try {
                    bis.close();
                }
                catch (IOException ioe) {
                    LogFactory.getLog(this.getClass()).warn((Object)"Unable to close stream.", (Throwable)ioe);
                }
            }
        }
        catch (IOException ioe) {
            throw new WebLabCheckedException("Unable to copy file.", (Throwable)ioe);
        }
    }

    public void saveFile(File file, String uri) throws WebLabCheckedException {
        File newFile = this.getFileFromWLRi(uri);
        if (!newFile.getParentFile().exists() && !newFile.getParentFile().mkdirs()) {
            LogFactory.getLog(this.getClass()).warn((Object)"Unable to create parent directory.");
        }
        this.copyAFile(file, newFile);
    }

    public static BinaryFolderContentManager getInstance(String folderPath) throws WebLabUncheckedException {
        BinaryFolderContentManager binaryFolderContentManager = map.get(folderPath);
        if (binaryFolderContentManager == null) {
            binaryFolderContentManager = new BinaryFolderContentManager(folderPath);
            map.put(folderPath, binaryFolderContentManager);
        }
        return binaryFolderContentManager;
    }

    public static BinaryFolderContentManager getInstance() throws WebLabUncheckedException {
        return BinaryFolderContentManager.getInstance(FolderContentManager.getPropertyValue("contentManager.properties", "binarycontentpath", "binarycontent"));
    }
}

