/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.content.api;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.content.api.ContentReader;
import org.ow2.weblab.content.api.ContentUtil;
import org.ow2.weblab.content.api.ContentWriter;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.processing.WProcessingAnnotator;
import org.ow2.weblab.rdf.Value;

public class ContentManager {
    public static final String CONTENT_MANAGER_PROPERTIES_FILE = "contentManager.properties";
    public static final String READER_IMPLEMENTATION = "reader.implementation";
    public static final String READER_DEFAULT_IMPLEMENTATION = "org.ow2.weblab.content.impl.FileContentManager";
    public static final String WRITER_IMPLEMENTATION = "writer.implementation";
    public static final String WRITER_DEFAULT_IMPLEMENTATION = "org.ow2.weblab.content.impl.FileContentManager";
    protected static Boolean loaded = Boolean.FALSE;
    protected static ContentManager instance;
    protected static ContentWriter writer;
    protected static ContentReader reader;
    protected final Log logger = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentManager getInstance() {
        try {
            Boolean bl = loaded;
            synchronized (bl) {
                if (!loaded.booleanValue() || instance == null) {
                    instance = new ContentManager();
                    instance.loadReaderImpl();
                    instance.loadWriterImpl();
                    loaded = Boolean.TRUE;
                }
            }
            return instance;
        }
        catch (ClassNotFoundException cnfe) {
            throw new WebLabUncheckedException("Cannot found one of the implementation.", (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            throw new WebLabUncheckedException("Cannot instanciate one of the implementation.", (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new WebLabUncheckedException("Error while constructing one of the implementation.", (Throwable)iae);
        }
    }

    private ContentManager() {
    }

    private void loadWriterImpl() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String writerImplName = ContentUtil.getPropertyValue(CONTENT_MANAGER_PROPERTIES_FILE, WRITER_IMPLEMENTATION, "org.ow2.weblab.content.impl.FileContentManager");
        Class<?> theClass = Class.forName(writerImplName);
        writer = (ContentWriter)theClass.newInstance();
        this.logger.info((Object)(writerImplName + " loaded as content writer."));
    }

    private void loadReaderImpl() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String readerImplName = ContentUtil.getPropertyValue(CONTENT_MANAGER_PROPERTIES_FILE, READER_IMPLEMENTATION, "org.ow2.weblab.content.impl.FileContentManager");
        Class<?> theClass = Class.forName(readerImplName);
        reader = (ContentReader)theClass.newInstance();
        this.logger.info((Object)(readerImplName + " loaded as content reader."));
    }

    public URI writeNativeContent(InputStream content, Resource res) throws WebLabCheckedException {
        URI destURI = writer.writeContent(content);
        WProcessingAnnotator wpa = new WProcessingAnnotator(res);
        wpa.writeNativeContent(destURI);
        return destURI;
    }

    public URI writeNormalisedContent(InputStream content, Resource res) throws WebLabCheckedException {
        URI destURI = writer.writeContent(content);
        WProcessingAnnotator wpa = new WProcessingAnnotator(res);
        wpa.writeNormalisedContent(destURI);
        return destURI;
    }

    public File readNativeContent(Resource res) throws WebLabCheckedException {
        WProcessingAnnotator wpa = new WProcessingAnnotator(res);
        Value values = wpa.readNativeContent();
        if (values == null || values.size() == 0) {
            throw new WebLabCheckedException("There is no native content defined on this resource [" + res.getUri() + "]");
        }
        if (values.size() > 1) {
            throw new WebLabCheckedException("There is multiple native content defined on this resource [" + res.getUri() + "]:" + values);
        }
        URI uri = (URI)values.getValues().get(0);
        return reader.readContent(uri);
    }

    public File readNormalisedContent(Resource res) throws WebLabCheckedException {
        WProcessingAnnotator wpa = new WProcessingAnnotator(res);
        Value values = wpa.readNormalisedContent();
        if (values == null || values.size() == 0) {
            throw new WebLabCheckedException("There is no native content defined on this resource [" + res.getUri() + "]");
        }
        if (values.size() > 1) {
            throw new WebLabCheckedException("There is multiple native content defined on this resource [" + res.getUri() + "]:" + values);
        }
        URI uri = (URI)values.getValues().get(0);
        return reader.readContent(uri);
    }
}

