/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.content.api;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.properties.PropertiesLoader;

public class ContentUtil {
    private static Log logger = LogFactory.getLog(ContentUtil.class);
    private static int BUFFER_SIZE = 1024;

    public static String getPropertyValue(String propertyPath, String propertyValue, String defaultValue) {
        String value;
        HashMap map;
        try {
            map = PropertiesLoader.loadProperties((String)propertyPath);
        }
        catch (WebLabUncheckedException wlue) {
            map = new HashMap(0);
        }
        if (map.containsKey(propertyValue)) {
            value = (String)map.get(propertyValue);
        } else {
            logger.warn((Object)("Unable to load '" + propertyValue + "' from file '" + propertyPath + "'. Using default value [" + defaultValue + "]."));
            value = defaultValue;
        }
        logger.debug((Object)("Loaded : '" + value + "' as [" + propertyValue + "]."));
        return value;
    }

    public static void writeStream(InputStream is, OutputStream os) throws IOException {
        int numRead;
        byte[] buf = new byte[BUFFER_SIZE];
        while ((numRead = is.read(buf)) >= 0) {
            os.write(buf, 0, numRead);
        }
        is.close();
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File newFile) throws WebLabCheckedException {
        byte[] tab = new byte[BUFFER_SIZE];
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            try {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(newFile, true));
                try {
                    int readed = bis.read(tab);
                    while (readed != -1) {
                        bos.write(tab, 0, readed);
                        readed = bis.read(tab);
                    }
                }
                finally {
                    try {
                        bos.close();
                    }
                    catch (IOException ioe) {
                        logger.warn((Object)"Unable to close stream.", (Throwable)ioe);
                    }
                }
            }
            finally {
                try {
                    bis.close();
                }
                catch (IOException ioe) {
                    logger.warn((Object)"Unable to close stream.", (Throwable)ioe);
                }
            }
        }
        catch (IOException ioe) {
            throw new WebLabCheckedException("Unable to copy file.", (Throwable)ioe);
        }
    }

    public static boolean equals(File one, File another) throws WebLabCheckedException {
        if (one == null || another == null) {
            return false;
        }
        if (one.length() != another.length()) {
            return false;
        }
        return ContentUtil.SHA1(one).compareTo(ContentUtil.SHA1(another)) == 0;
    }

    public static boolean equals(byte[] one, byte[] another) throws WebLabCheckedException {
        if (one == null || another == null) {
            return false;
        }
        if (one.length != another.length) {
            return false;
        }
        return ContentUtil.SHA1(one).compareTo(ContentUtil.SHA1(another)) == 0;
    }

    public static String SHA1(File in) throws WebLabCheckedException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            FileInputStream fis = new FileInputStream(in);
            byte[] sha1hash = new byte[40];
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            sha1hash = md.digest();
            String hash = ContentUtil.convertToHex(sha1hash);
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new WebLabCheckedException("Cannot load SHA1 algorithm.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new WebLabCheckedException("Cannot load file [" + in + "] for SHA1 computation.", (Throwable)e);
        }
        catch (IOException e) {
            throw new WebLabCheckedException("Cannot access content of file [" + in + "] for SHA1 computation.", (Throwable)e);
        }
    }

    public static String SHA1(byte[] dataBytes) throws WebLabCheckedException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] sha1hash = new byte[40];
            md.update(dataBytes, 0, dataBytes.length);
            sha1hash = md.digest();
            String hash = ContentUtil.convertToHex(sha1hash);
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new WebLabCheckedException("Cannot load SHA1 algorithm.", (Throwable)e);
        }
    }

    public static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (byte element : data) {
            int halfbyte = element >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = element & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }
}

