/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.content.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.ow2.weblab.content.api.ContentReader;
import org.ow2.weblab.content.api.ContentUtil;
import org.ow2.weblab.content.api.ContentWriter;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;

public class FileContentManager
implements ContentReader,
ContentWriter {
    public static final String FILE_CONTENT_MANAGER_PROPERTIES_FILE = "fileContentManager.properties";
    public static final String FILE_SCHEME = "file";
    public static final String FOLDER_CONTENT_PATH = "file.path";
    public static final String FOLDER_CONTENT_DEFAULT_PATH = "data/content";
    public static final String PREFIX = "weblab.";
    public static final String SUFFIX = ".content";
    private String contentFolderPath;
    private File contentFolder;

    public FileContentManager() {
        this.setContentFolderPath(ContentUtil.getPropertyValue(FILE_CONTENT_MANAGER_PROPERTIES_FILE, FOLDER_CONTENT_PATH, FOLDER_CONTENT_DEFAULT_PATH));
    }

    @Override
    public URI writeContent(InputStream content) throws WebLabCheckedException {
        try {
            File contentFile = File.createTempFile(PREFIX, SUFFIX, this.contentFolder);
            ContentUtil.writeStream(content, new FileOutputStream(contentFile));
            return contentFile.toURI();
        }
        catch (IOException e) {
            throw new WebLabCheckedException("Cannot create file in content folder [" + this.contentFolder + "].", (Throwable)e);
        }
    }

    @Override
    public URI writeExposedContent(InputStream content) throws WebLabCheckedException {
        return this.writeContent(content);
    }

    @Override
    public File readContent(URI destUri) throws WebLabCheckedException {
        if (destUri.getScheme().compareTo(FILE_SCHEME) != 0) {
            throw new WebLabCheckedException("Invalid URI scheme [" + destUri.getScheme() + "], only [" + FILE_SCHEME + "] is valid.");
        }
        File toRead = new File(destUri);
        if (!toRead.exists() || !toRead.canRead()) {
            throw new WebLabCheckedException("File [" + destUri.getScheme() + "] does not exists or is not readable.");
        }
        return toRead;
    }

    public String getContentFolderPath() {
        return this.contentFolderPath;
    }

    protected void setContentFolderPath(String contentFolderPath) {
        File folder = new File(contentFolderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!folder.exists()) {
            throw new WebLabUncheckedException("Content folder [" + folder + "] does not exists or is not readable.");
        }
        if (!folder.canWrite()) {
            throw new WebLabUncheckedException("Cannot write in content folder [" + folder + "].");
        }
        if (folder.isFile()) {
            throw new WebLabUncheckedException("Content folder [" + folder + "] is a File instead of a directory.");
        }
        this.contentFolderPath = contentFolderPath;
        this.contentFolder = folder;
    }
}

