/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.content.api;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.content.api.ContentReader;
import org.ow2.weblab.content.api.ContentWriter;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.properties.PropertiesLoader;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.processing.WProcessingAnnotator;
import org.ow2.weblab.rdf.Value;

public class ContentManager {
    public static final String CONTENT_MANAGER_PROPERTIES_FILE = "contentManager.properties";
    public static final String READER_IMPLEMENTATION = "reader.implementation";
    public static final String READER_DEFAULT_IMPLEMENTATION = "org.ow2.weblab.content.impl.FileContentManager";
    public static final String WRITER_IMPLEMENTATION = "writer.implementation";
    public static final String WRITER_DEFAULT_IMPLEMENTATION = "org.ow2.weblab.content.impl.FileContentManager";
    protected static ContentManager instance;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final ContentWriter writer;
    protected final ContentReader reader = ContentManager.loadReaderImpl();

    public static synchronized ContentManager getInstance() {
        try {
            if (instance == null) {
                instance = new ContentManager();
            }
            return instance;
        }
        catch (ClassNotFoundException cnfe) {
            throw new WebLabUncheckedException("Cannot found one of the implementation.", (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            throw new WebLabUncheckedException("Cannot instanciate one of the implementation.", (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new WebLabUncheckedException("Error while constructing one of the implementation.", (Throwable)iae);
        }
    }

    private ContentManager() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.logger.info((Object)(this.reader.getClass().getCanonicalName() + " loaded as content reader."));
        this.writer = ContentManager.loadWriterImpl();
        this.logger.info((Object)(this.writer.getClass().getCanonicalName() + " loaded as content writer."));
    }

    private static ContentWriter loadWriterImpl() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String writerImplName = ContentManager.getPropertyValue(CONTENT_MANAGER_PROPERTIES_FILE, WRITER_IMPLEMENTATION, "org.ow2.weblab.content.impl.FileContentManager");
        Class<?> theClass = Class.forName(writerImplName);
        return (ContentWriter)theClass.newInstance();
    }

    private static ContentReader loadReaderImpl() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String readerImplName = ContentManager.getPropertyValue(CONTENT_MANAGER_PROPERTIES_FILE, READER_IMPLEMENTATION, "org.ow2.weblab.content.impl.FileContentManager");
        Class<?> theClass = Class.forName(readerImplName);
        return (ContentReader)theClass.newInstance();
    }

    public static String getPropertyValue(String propertyPath, String propertyKey, String defaultValue) {
        String value;
        Map map;
        try {
            map = PropertiesLoader.loadProperties((String)propertyPath);
        }
        catch (WebLabUncheckedException wlue) {
            LogFactory.getLog(ContentManager.class).debug((Object)("No property file found. Return default value [" + defaultValue + "] for property [" + propertyKey + "]."), (Throwable)wlue);
            return defaultValue;
        }
        if (map.containsKey(propertyKey)) {
            value = (String)map.get(propertyKey);
            LogFactory.getLog(ContentManager.class).debug((Object)("Using [" + value + "] for property [" + propertyKey + "]."));
        } else {
            LogFactory.getLog(ContentManager.class).debug((Object)("No value found for property [" + propertyKey + "]. Return default value [" + defaultValue + "]."));
            value = defaultValue;
        }
        map.clear();
        return value;
    }

    public URI writeNativeContent(InputStream content, Resource res) throws WebLabCheckedException {
        URI destURI = this.writer.writeContent(content);
        WProcessingAnnotator wpa = new WProcessingAnnotator(res);
        wpa.writeNativeContent(destURI);
        return destURI;
    }

    public URI writeNormalisedContent(InputStream content, Resource res) throws WebLabCheckedException {
        URI destURI = this.writer.writeContent(content);
        WProcessingAnnotator wpa = new WProcessingAnnotator(res);
        wpa.writeNormalisedContent(destURI);
        return destURI;
    }

    public File readNativeContent(Resource res) throws WebLabCheckedException {
        WProcessingAnnotator wpa = new WProcessingAnnotator(res);
        Value values = wpa.readNativeContent();
        if (values == null || values.size() == 0) {
            throw new WebLabCheckedException("There is no native content defined on this resource [" + res.getUri() + "]");
        }
        if (values.size() > 1) {
            throw new WebLabCheckedException("There is multiple native content defined on this resource [" + res.getUri() + "]:" + values);
        }
        URI uri = (URI)values.getValues().get(0);
        return this.reader.readContent(uri);
    }

    public File readNormalisedContent(Resource res) throws WebLabCheckedException {
        WProcessingAnnotator wpa = new WProcessingAnnotator(res);
        Value values = wpa.readNormalisedContent();
        if (values == null || values.size() == 0) {
            throw new WebLabCheckedException("There is no native content defined on this resource [" + res.getUri() + "]");
        }
        if (values.size() > 1) {
            throw new WebLabCheckedException("There is multiple native content defined on this resource [" + res.getUri() + "]:" + values);
        }
        URI uri = (URI)values.getValues().get(0);
        return this.reader.readContent(uri);
    }

    public ContentReader getReader() {
        return this.reader;
    }

    public ContentWriter getWriter() {
        return this.writer;
    }
}

