package org.ow2.weblab.content.impl;

import java.io.File;
import java.net.URI;

import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;

public final class SecureFileContentManager extends FileContentManager {

	public SecureFileContentManager() {
		//Nothing special to do
	}

	/**
	 * This method overrides the unsecure one by verifying if the generated path for
	 * files is a child of the file content manager path
	 */
	@Override
	public File readContent(URI destUri) throws WebLabCheckedException {
		File fileToSecure_l = super.readContent(destUri);
		
		//Check that the file returned by the parent function is inside our path
		URI contentFolderURI_l = getContentFolder().toURI();
		URI fileToSecureURI_l = fileToSecure_l.toURI();
		
		URI resultingURI_l = contentFolderURI_l.relativize(fileToSecureURI_l);
		getLogger().debug("URI relativized : " + resultingURI_l);
		if ((resultingURI_l.compareTo(fileToSecureURI_l) == 0) || (resultingURI_l.isAbsolute())) {
			throw new WebLabUncheckedException("File " + fileToSecure_l.getPath() + " is not within Content Manager repository");
		}
			
		return fileToSecure_l;
	}
}
