/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.content.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.content.api.ContentManager;
import org.ow2.weblab.content.api.ContentReader;
import org.ow2.weblab.content.api.ContentWriter;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;

public class FileContentManager
implements ContentReader,
ContentWriter {
    public static final String FILE_CONTENT_MANAGER_PROPERTIES_FILE = "fileContentManager.properties";
    public static final String NETWORK_SCHEMES = "http:ftp:https";
    public static final String FILE_SCHEME = "file";
    public static final String FOLDER_CONTENT_PATH = "file.path";
    public static final String FOLDER_CONTENT_DEFAULT_PATH = "data/content";
    public static final String PREFIX = "weblab.";
    public static final String SUFFIX = ".content";
    private String contentFolderPath;
    private File contentFolder;
    private final Log logger = LogFactory.getLog(this.getClass());

    public FileContentManager() {
        this.setContentFolderPath(ContentManager.getPropertyValue(FILE_CONTENT_MANAGER_PROPERTIES_FILE, FOLDER_CONTENT_PATH, FOLDER_CONTENT_DEFAULT_PATH));
    }

    @Override
    public URI writeContent(InputStream content) throws WebLabCheckedException {
        try {
            File contentFile = File.createTempFile(PREFIX, SUFFIX, this.contentFolder);
            FileUtils.copyInputStreamToFile((InputStream)content, (File)contentFile);
            URI uRI = contentFile.toURI();
            return uRI;
        }
        catch (IOException ioe) {
            throw new WebLabCheckedException("Cannot create file in content folder [" + this.contentFolder + "].", (Throwable)ioe);
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
        }
    }

    @Override
    public URI writeExposedContent(InputStream content) throws WebLabCheckedException {
        this.logger.warn((Object)"Not yet implemented !!!");
        return this.writeContent(content);
    }

    @Override
    public File readContent(URI destUri) throws WebLabCheckedException {
        File toRead;
        if (!destUri.isAbsolute()) {
            throw new WebLabCheckedException("Invalid URI, scheme is null in " + destUri);
        }
        String scheme = destUri.getScheme();
        URI finalURI = destUri;
        if (NETWORK_SCHEMES.contains(scheme)) {
            try {
                URL url = destUri.toURL();
                finalURI = this.writeContent(url.openStream());
                toRead = new File(finalURI);
            }
            catch (MalformedURLException e) {
                this.logger.error((Object)e, (Throwable)e);
                throw new WebLabCheckedException("Network resource URL is malformed : " + destUri, (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error((Object)e, (Throwable)e);
                throw new WebLabCheckedException("Network resource URL can not be accessed : " + destUri, (Throwable)e);
            }
        } else {
            if (!FILE_SCHEME.equalsIgnoreCase(scheme)) {
                throw new WebLabCheckedException("Invalid URI scheme [" + scheme + "], only [" + FILE_SCHEME + "] is valid.");
            }
            if (!finalURI.isOpaque()) {
                toRead = new File(finalURI);
            } else {
                String path_l = finalURI.getPath();
                path_l = finalURI.toASCIIString().replaceFirst(finalURI.getScheme() + ":", "");
                this.logger.debug((Object)("Relative Path used for reading : " + path_l));
                toRead = new File(this.contentFolderPath, path_l);
            }
        }
        if (!toRead.exists()) {
            throw new WebLabCheckedException("File [" + toRead.getPath() + "] does not exists.");
        }
        if (!toRead.isFile()) {
            throw new WebLabCheckedException("File [" + toRead.getPath() + "] is not a file.");
        }
        if (!toRead.canRead()) {
            throw new WebLabCheckedException("File [" + toRead.getPath() + "] is not readable.");
        }
        return toRead;
    }

    public String getContentFolderPath() {
        return this.contentFolderPath;
    }

    protected void setContentFolderPath(String contentFolderPath) {
        File folder = new File(contentFolderPath);
        try {
            FileUtils.forceMkdir((File)folder);
        }
        catch (IOException ioe) {
            throw new WebLabUncheckedException("Unable to create Content folder [" + folder + "].", (Throwable)ioe);
        }
        if (!folder.exists()) {
            throw new WebLabUncheckedException("Content folder [" + folder + "] does not exists or is not readable.");
        }
        if (!folder.canWrite()) {
            throw new WebLabUncheckedException("Cannot write in content folder [" + folder + "].");
        }
        if (folder.isFile()) {
            throw new WebLabUncheckedException("Content folder [" + folder + "] is a File instead of a directory.");
        }
        this.contentFolderPath = contentFolderPath;
        this.logger.info((Object)("file.path=" + this.contentFolderPath));
        this.contentFolder = folder;
    }

    protected File getContentFolder() {
        return this.contentFolder;
    }

    protected Log getLogger() {
        return this.logger;
    }
}

