/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.content.impl;

import java.io.File;
import java.net.URI;
import org.ow2.weblab.content.impl.FileContentManager;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;

public final class SecureFileContentManager
extends FileContentManager {
    @Override
    public File readContent(URI destUri) throws WebLabCheckedException {
        File fileToSecure_l = super.readContent(destUri);
        URI contentFolderURI_l = this.getContentFolder().toURI();
        URI fileToSecureURI_l = fileToSecure_l.toURI();
        URI resultingURI_l = contentFolderURI_l.relativize(fileToSecureURI_l);
        this.getLogger().debug((Object)("URI relativized : " + resultingURI_l));
        if (resultingURI_l.compareTo(fileToSecureURI_l) == 0 || resultingURI_l.isAbsolute()) {
            throw new WebLabUncheckedException("File " + fileToSecure_l.getPath() + " is not within Content Manager repository");
        }
        return fileToSecure_l;
    }
}

