/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.content;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.content.ContentManager;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.model.Resource;

public class FileContentManager
extends ContentManager {
    public static final String FILE_SCHEME = "file";
    public static final String FOLDER_CONTENT_PATH = "file.path";
    public static final String PREFIX = "weblab.";
    public static final String SUFFIX = ".content";
    public static Log logger = LogFactory.getLog(FileContentManager.class);
    private String contentFolderPath;
    private File contentFolder;

    protected FileContentManager() {
        this.setContentFolderPath(ContentManager.getPropertyValue(FOLDER_CONTENT_PATH, "/tmp"));
    }

    @Override
    protected URI saveContent(InputStream content, Resource res) throws WebLabCheckedException {
        try {
            File contentFile = File.createTempFile(PREFIX, SUFFIX, this.contentFolder);
            ContentManager.writeStream(content, new FileOutputStream(contentFile));
            return contentFile.toURI();
        }
        catch (IOException e) {
            throw new WebLabCheckedException("Cannot create file in content folder [" + this.contentFolder + "].", (Throwable)e);
        }
    }

    @Override
    protected File readContent(Resource res, URI destUri) throws WebLabCheckedException {
        if (destUri.getScheme().compareTo(FILE_SCHEME) != 0) {
            throw new WebLabCheckedException("Invalid URI scheme [" + destUri.getScheme() + "], only [" + FILE_SCHEME + "] is valid.");
        }
        File toRead = new File(destUri);
        if (!toRead.exists() || !toRead.canRead()) {
            throw new WebLabCheckedException("File [" + destUri.getScheme() + "] does not exists or is not readable.");
        }
        return toRead;
    }

    public String getContentFolderPath() {
        return this.contentFolderPath;
    }

    protected void setContentFolderPath(String contentFolderPath) {
        this.contentFolderPath = contentFolderPath;
        logger.info((Object)("file.path=" + this.contentFolderPath));
        this.contentFolder = new File(this.contentFolderPath);
        if (!this.contentFolder.exists()) {
            this.contentFolder.mkdirs();
        }
        if (!this.contentFolder.exists()) {
            throw new WebLabUncheckedException("Content folder [" + this.contentFolder + "] does not exists or is not readable.");
        }
        if (!this.contentFolder.canWrite()) {
            throw new WebLabUncheckedException("Cannot write in content folder [" + this.contentFolder + "].");
        }
        if (this.contentFolder.isFile()) {
            throw new WebLabUncheckedException("Content folder [" + this.contentFolder + "] is a File instead of a directory.");
        }
    }
}

