/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2012 CASSIDIAN an EADS Company
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.content;

import java.io.File;
import java.io.InputStream;
import java.net.URI;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.model.Resource;

/**
 * @deprecated use org.ow2.weblab.content.api.ContentManager instead.
 * @author gdupont - WebLab team ; CASSIDIAN, an EADS company
 * @date 2011 WebLab model 1.2.1
 */
@Deprecated
public class ContentManager {


	public static final String CONTENT_MANAGER_PROPERTIES_FILE = "contentManager.properties";


	public static final String CONTENT_MANAGER_IMPLEMENTATION = "content.manager.implementation";


	public static int BUFFER_SIZE = 1024;


	protected final Log logger;


	protected static ContentManager instance;


	protected static Boolean loaded = Boolean.FALSE;


	@Deprecated
	public static ContentManager getInstance() {
		return new ContentManager();
	}


	/**
	 * The default constructor that initialises the logger.
	 */
	public ContentManager() {
		this.logger = LogFactory.getLog(this.getClass());
	}


	@Deprecated
	public URI saveNativeContent(final InputStream content, final Resource res) throws WebLabCheckedException {
		this.logger.warn("Do not use this deprecated API any more. Use org.ow2.weblab.content.api.ContentManager");
		return org.ow2.weblab.content.api.ContentManager.getInstance().writeNativeContent(content, res);
	}


	@Deprecated
	public URI saveNormalisedContent(final InputStream content, final Resource res) throws WebLabCheckedException {
		this.logger.warn("Do not use this deprecated API any more. Use org.ow2.weblab.content.api.ContentManager");
		return org.ow2.weblab.content.api.ContentManager.getInstance().writeNormalisedContent(content, res);
	}


	@Deprecated
	public File readNativeContent(final Resource res) throws WebLabCheckedException {
		this.logger.warn("Do not use this deprecated API any more. Use org.ow2.weblab.content.api.ContentManager");
		return org.ow2.weblab.content.api.ContentManager.getInstance().readNativeContent(res);
	}


	@Deprecated
	public File readNormalisedContent(final Resource res) throws WebLabCheckedException {
		this.logger.warn("Do not use this deprecated API any more. Use org.ow2.weblab.content.api.ContentManager");
		return org.ow2.weblab.content.api.ContentManager.getInstance().readNormalisedContent(res);
	}
}
